% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{wci}
\alias{wci}
\title{Wind chill index}
\usage{
wci(taverage, w, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{taverage}{daily mean temperature, Celsius}

\item{w}{average wind, m/s}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
index value
}
\description{
Wind chill index is the lowering of body temperature due to the passing-flow of lower-temperature air. It combines air temperature and wind speed.
}
\section{Formula}{
 \deqn{WCI = 13.12 + 0.6215 * TG - 11.37 * v ^ {+ 0.16} +  0.3965 * TG * v ^ {+ 0.16}} Where TG in celsius and v is wind speed in Km/h
}

\examples{
data(data_all)
wci(taverage = data_all$tg, w = data_all$wind)
}
\references{
Osczevski, Randall; Bluestein, Maurice (2005). The new wind chill equivalent temperature chart. Bulletin of the American Meteorological Society. 86 (10): 1453–1458
}
