% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{hi}
\alias{hi}
\title{Heat Index}
\usage{
hi(taverage, rh, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{taverage}{daily mean temperature, Celsius}

\item{rh}{relative humidity, percentage}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
index value
}
\description{
Combines air temperature and relative humidity to determine the human-perceived equivalent temperature
}
\section{Formula}{
 \deqn{HI= -42,379+2,04901523*TG+10,14333127*rh-0,22475541*TG*rh-0.00683783*TG^2-0.05481717*rh^2+0.0122874*TG^2*rh+0.00085282*TG*rh^2-0.00000199*TG^2*rh^2}. Where TG is air temperature in ºF and rh is relative humidity in %
}

\examples{
data(data_all)
hi(taverage = data_all$tg, rh = data_all$humidity)
}
\references{
The Heat Index Equation \url{https://www.wpc.ncep.noaa.gov/html/heatindex_equation.shtml}
}
