/*
 * Decompiled with CFR 0.152.
 */
package core.explorer;

import core.explorer.ChordalysisModeller;
import core.model.ScoredGraphAction;
import core.stats.EntropyComputer;
import core.stats.scorer.GraphActionScorer;
import core.stats.scorer.GraphActionScorerPValue;

public class ChordalysisModellingSMT
extends ChordalysisModeller {
    double pValueThreshold;

    public ChordalysisModellingSMT(ChordalysisModeller.Data data, double pValueThreshold) {
        super(data);
        this.pValueThreshold = pValueThreshold;
    }

    @Override
    protected GraphActionScorer initScorer() {
        EntropyComputer entropyComputer = new EntropyComputer(this.lattice);
        return new GraphActionScorerPValue(entropyComputer);
    }

    @Override
    public void explore() {
        this.pq.processStoredModifications();
        double remainingBudget = this.pValueThreshold;
        int step = 0;
        while (!this.pq.isEmpty() && step < this.maxNSteps) {
            int nTests = this.pq.size();
            double correctedPValueThreshold = remainingBudget / (double)nTests;
            ScoredGraphAction todo = (ScoredGraphAction)this.pq.poll();
            if (todo.getScore() > correctedPValueThreshold) break;
            double usedBudget = todo.getScore() * (double)nTests;
            remainingBudget -= usedBudget;
            this.operationsPerformed.add(todo);
            this.bestModel.performAction(todo, this.bestModel, this.pq);
            ++step;
        }
    }
}

