% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariate_plots.R
\name{res_vs_cov}
\alias{res_vs_cov}
\title{Residuals vs covariate plot}
\usage{
res_vs_cov(
  xpdb,
  mapping = NULL,
  covariate,
  res = "CWRES",
  group = "ID",
  type = "bpls",
  title = "Residuals vs @x | @run",
  subtitle = "Based on @nind individuals",
  caption = "@dir",
  tag = NULL,
  log = NULL,
  guide = TRUE,
  facets,
  .problem,
  quiet,
  ...
)
}
\arguments{
\item{xpdb}{An xpose database object.}

\item{mapping}{List of aesthetics mappings to be used for the xpose plot
(e.g. \code{point_color}).}

\item{covariate}{Character; String of covariate name}

\item{res}{Character; String of residual name; CWRES by default.}

\item{group}{Grouping variable to be used for lines. \code{ID} by default}

\item{type}{Character; String setting the type of plot to be used.
Must be 'b' for categorical covariates,
one or a combination of 'p','l','s' for continuous covariates.}

\item{title}{Character; Plot title. Use \code{NULL} to remove.}

\item{subtitle}{Character; Plot subtitle. Use \code{NULL} to remove.}

\item{caption}{Character; Page caption. Use \code{NULL} to remove.}

\item{tag}{Character; Plot identification tag. Use \code{NULL} to remove.}

\item{log}{Character; String assigning logarithmic scale to axes, can be either '',
'x', y' or 'xy'.}

\item{guide}{Logical; Should the guide (e.g. reference distribution) be displayed.}

\item{facets}{Either a character string to use \code{\link[ggforce]{facet_wrap_paginate}}
or a formula to use \code{\link[ggforce]{facet_grid_paginate}}.}

\item{.problem}{The $problem number to be used. By default returns
the last estimation problem.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}

\item{...}{Any additional aesthetics to be passed on \code{\link[xpose]{xplot_scatter}}
or \code{\link{xplot_box}}.}
}
\value{
An object of class \code{xpose_plot}, \code{ggplot}, and \code{gg}. This object represents a customized plot created using \code{ggplot2}.
The \code{xpose_plot} class provides additional metadata and integration with \code{xpose} workflows, allowing for advanced
customization and compatibility with other \code{xpose} functions. Users can interact with the plot object as they
would with any \code{ggplot2} object, including modifying aesthetics, adding layers, or saving the plot.
}
\description{
Plot Residuals against a continuous or categorical covariate.
}
\section{Layers mapping}{

Plots can be customized by mapping arguments to specific layers. The naming convention is
layer_option where layer is one of the names defined in the list below and option is
any option supported by this layer e.g. \code{boxplot_fill = 'blue'}, etc.
\itemize{
  \item box plot: options to \code{geom_boxplot}
  \item point plot: options to \code{geom_point}
  \item line plot: options to \code{geom_line}
  \item smooth plot: options to \code{geom_smooth}
  \item xscale: options to \code{scale_x_continuous} or \code{scale_x_log10}
  \item yscale: options to \code{scale_y_continuous} or \code{scale_y_log10}
}
}

\examples{
res_vs_cov(xpose::xpdb_ex_pk,
  covariate = "SEX",
  type = "b",
  res = "WRES"
)

res_vs_cov(xpose::xpdb_ex_pk,
  covariate = "AGE",
  type = "ps",
  res = c("CWRES", "WRES", "IRES", "IWRES")
)

}
\seealso{
\code{\link[xpose]{xplot_scatter}} \code{\link{xplot_box}}
}
