% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pyDarwinOptionsMOGA.R
\name{pyDarwinOptionsMOGA}
\alias{pyDarwinOptionsMOGA}
\title{Create Options for the pyDarwin MOGA Block}
\usage{
pyDarwinOptionsMOGA(
  objectives = 3,
  names = NULL,
  constraints = 0,
  partitions = 12,
  crossover = "single",
  crossover_rate = 0.95,
  mutation_rate = 0.95,
  attribute_mutation_probability = 0.1
)
}
\arguments{
\item{objectives}{Positive integer: Number of objectives.
Applicable only when the \code{algorithm} in \code{create_pyDarwinOptions()}
is set to "MOGA3". If the \code{algorithm} is "MOGA" (implying NSGA-II),
this parameter is ignored by pyDarwin, and 2 objectives (OFV and NEP)
are used internally. For "MOGA3", objectives are defined by
postprocessing.
Default: 3 (relevant for "MOGA3").}

\item{names}{Character vector (optional): List of names for the objectives.
Applicable only when the \code{algorithm} is "MOGA3". The length of
this vector should match the \code{objectives} value. If \code{NULL}, empty, or of
a different size, pyDarwin uses generic names (e.g., "f1", "f2", "f3").
These names are used for reporting in \code{results.csv}. Ignored if the
\code{algorithm} is "MOGA".
Default: NULL.}

\item{constraints}{Non-negative integer: Number of constraints.
Applicable only when the \code{algorithm} is "MOGA3". Constraints must be
provided by user-defined postprocessing scripts (R or Python).
See \url{https://pymoo.org/constraints/index.html}. Ignored if the
\code{algorithm} is "MOGA".
Default: 0.}

\item{partitions}{Positive integer: Number of partitions for the reference
directions used in NSGA-III.
Applicable only when the \code{algorithm} is "MOGA3".
See \url{https://pymoo.org/misc/reference_directions.html}. Ignored if the
\code{algorithm} is "MOGA".
Default: 12.}

\item{crossover}{Character string: Crossover algorithm.
When set to "single", SinglePointCrossover is used. Otherwise, for other
values like "two_point", TwoPointCrossover is typically used by pymoo.
See \url{https://pymoo.org/operators/crossover.html#Point-Crossover}.
Applicable for both "MOGA" and "MOGA3".
Default: "single".}

\item{crossover_rate}{Numeric value between 0.0 and 1.0: The fraction of
mating pairs that will undergo crossover. Applicable for both "MOGA" and
"MOGA3".
Default: 0.95.}

\item{mutation_rate}{Numeric value between 0.0 and 1.0: The probability
that at least one bit in the genome will be "flipped" (mutated).
Applicable for both "MOGA" and "MOGA3".
Default: 0.95.}

\item{attribute_mutation_probability}{Numeric value between 0.0 and 1.0:
The probability of any individual bit (attribute) in the genome being
mutated. Applicable for both "MOGA" and "MOGA3".
Default: 0.1.}
}
\value{
A list containing MOGA-specific options.
}
\description{
Generates a list of specific options for the MOGA (Multi-Objective Genetic
Algorithm) or MOGA3 (NSGA-III) algorithms in pyDarwin. This list is
intended to be passed as the \code{MOGA} argument to the
\code{create_pyDarwinOptions()} function when \code{algorithm} is set to "MOGA" or
"MOGA3".
}
\details{
This function defines parameters for the \code{MOGA} settings block in pyDarwin.
The relevance of certain parameters (\code{objectives}, \code{names}, \code{constraints},
\code{partitions}) depends on whether the \code{algorithm} in
\code{create_pyDarwinOptions()} is set to "MOGA" (for NSGA-II) or "MOGA3"
(for NSGA-III).
\itemize{
\item If \code{algorithm = "MOGA"} (NSGA-II):
pyDarwin internally uses 2 objectives (OFV and NEP). The \code{objectives},
\code{names}, \code{constraints}, and \code{partitions} parameters from this MOGA options
block are ignored by pyDarwin. Postprocessing scripts are not used by
pyDarwin to define objectives.
\item If \code{algorithm = "MOGA3"} (NSGA-III):
The \code{objectives}, \code{names}, \code{constraints}, and \code{partitions} parameters
from this MOGA options block are utilized by pyDarwin. User-supplied
postprocessing scripts (R or Python) are \strong{required} to calculate and
return the values for the objectives and constraints.
(R: list of two vectors; Python: tuple of two lists).
}

Common parameters like \code{crossover}, \code{crossover_rate}, \code{mutation_rate}, and
\code{attribute_mutation_probability} apply to both "MOGA" and "MOGA3" variants.
}
\examples{
# MOGA options, defaults are generally suitable for algorithm = "MOGA3"
# if postprocessing handles 3 objectives.
moga_block_for_moga3 <- pyDarwinOptionsMOGA(
  objectives = 3,
  names = c("Objective1", "Objective2", "Objective3"),
  constraints = 1,
  partitions = 10
)

# MOGA options where specific settings are for NSGA-II (algorithm = "MOGA")
# Note: objectives, names, constraints, partitions would be ignored by pyDarwin.
moga_block_for_moga <- pyDarwinOptionsMOGA(
  crossover = "two_point",
  crossover_rate = 0.92
)

}
