% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_Covariate.R
\name{add_Covariate}
\alias{add_Covariate}
\title{Add Covariate into PML models}
\usage{
add_Covariate(
  PMLParametersSets,
  Name,
  Type = "Continuous",
  StParmNames = NULL,
  State = "Present",
  Direction = "Forward",
  Center = "None",
  Categories = c(),
  PMLStructures = NULL
)
}
\arguments{
\item{PMLParametersSets}{A list of PML parameters sets (\code{PMLModels} class
instance).}

\item{Name}{A character string representing the name of the covariate to be
added.}

\item{Type}{A character specifying the type of the covariate.
Possible values are:
\itemize{
\item \code{Continuous} A covariate  can take values on a continuous scale.
\item \code{Categorical} A covariate can only take a finite number of values.
\item \code{Occasion} The associated PK parameter may vary within an individual
from one event to the next, called interoccasion variability.
}}

\item{StParmNames}{Character or character vector specifying names of
structural parameters to which covariates should be added. Can be set to
\code{NULL} or not specified, for such case, covariate will be added to all
structural parameters.}

\item{State}{A character string representing the presence of the covariate on the structural parameters. Possible values are:
\itemize{
\item \code{None} The covariate does not have an effect on any structural parameter.
\item \code{Present} The covariate has an effect on the structural parameters (the default).
\item \code{Searched} The effect of the covariate on structural parameters is searched.
}}

\item{Direction}{A character string representing the direction of the
Covariate. Options are \code{Forward}, \code{Backward}, \code{Interpolate}. Default is
\code{Forward}. \code{Interpolate} is only applicable to \code{Type == "Continuous"}.}

\item{Center}{A character string (\code{None}, \code{Mean} or \code{Median}) or numeric
value representing the center of the Covariate. Default is \code{None}. Valid
only if \code{Type == "Continuous"}.}

\item{Categories}{A numeric vector representing the categories (at least two)
of the covariate. Applicable only if \code{Type} is either \code{Occasion} or
\code{Categorical}. The first category is set to the reference category for
categorical covariate. If a named vector is used, the names are used as
labels for the given dataset,}

\item{PMLStructures}{Character or character vector specifying names of PML
structures to which the covariate will be added. For the naming covention
of PMLStructures, see Details section of \code{\link[=create_ModelPK]{create_ModelPK()}} for PK models
and \code{\link[=create_ModelPD]{create_ModelPD()}} for PD models.}
}
\value{
An updated list of PML models (\code{PMLModels} class instance) matching
the specified options.
}
\description{
Add Covariate into PML models
}
\details{
\itemize{
\item If Covariate already exists, it will be substituted with a new
instance with given properties. New covariate will have default bound
omegas/thetas. The user can change thetas with \code{\link[=modify_Theta]{modify_Theta()}} and omegas
with \code{\link[=modify_Omega]{modify_Omega()}}.
\item The current functionality does not support adding or modifying custom
covariates that are defined within the PML code of custom model spaces.
}
}
\examples{
PMLParametersSets <- create_ModelPK()

PMLParametersSetsWT <-
 add_Covariate(PMLParametersSets,
               Name = "WT",
               Type = "Continuous",
               State = "Present",
               Direction = "Forward",
               Center = 70)

PMLParametersSetsWTCL <-
 add_Covariate(PMLParametersSets = PMLParametersSetsWT,
               Name = "Race",
               Type = "Categorical",
               State = "Searched",
               Direction = "Backward",
               Categories = c(1,2,3),
               StParmNames = "Cl",
               PMLStructure = "PK1IVC")

}
\seealso{
\code{\link[=list_Covariates]{list_Covariates()}} \code{\link[=modify_Theta]{modify_Theta()}} \code{\link[=modify_Omega]{modify_Omega()}}

Functions used for Covariate specification: 
\code{\link{Covariate}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{remove_Covariate}()}
}
\concept{Covariates}
