% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DosepointClass.R
\name{Dosepoint}
\alias{Dosepoint}
\title{Create a new Dosepoint object and validate it}
\usage{
Dosepoint(
  DosepointName = "A1",
  State = "Present",
  tlag = c(),
  bioavail = c(),
  duration = c(),
  rate = c(),
  PMLStructure = character()
)
}
\arguments{
\item{DosepointName}{A character string giving the name of the Dosepoint.}

\item{State}{A character string giving the state of the Dosepoint, must be
one of "None", "Present", "Searched". Default is "Present".}

\item{tlag}{An optional parameter for the time lag. Can be an
\code{\link{StParm}} object, an \code{\link{Expression}} object, or a
character string (which will be converted to an Expression).}

\item{bioavail}{An optional parameter for bioavailability. Can be an
\code{\link{StParm}} object, an \code{\link{Expression}} object, or a
character string (which will be converted to an Expression).}

\item{duration}{An optional parameter for the duration of infusion. Can be an
\code{\link{StParm}} object, an \code{\link{Expression}} object, or a
character string (which will be converted to an Expression).}

\item{rate}{An optional parameter for the rate of infusion. Can be an
\code{\link{StParm}} object, an \code{\link{Expression}} object, or a
character string (which will be converted to an Expression).}

\item{PMLStructure}{A character string that indicates a specific PML structure
this Dosepoint definition should be associated with.}
}
\value{
A new Dosepoint object.
}
\description{
Create a new Dosepoint object and validate it
}
\examples{
# Using StParm objects
TlagStParm <- StParm("Tlag",
                     Type = "LogNormal",
                     ThetaStParm = Theta(Name = "tvTlag", InitialEstimates = 0.1))
FStParm <- StParm("F", ThetaStParm = Theta(Name = "tvF")) # Assuming Theta exists

dp1 <- Dosepoint(DosepointName = "GutInput",
                 State = "Present",
                 tlag = TlagStParm,
                 bioavail = FStParm)

# Using Expression objects
dp2 <- Dosepoint(DosepointName = "Infusion",
                 rate = Expression("RateVal",
                                   ContainedStParms =
                                     list(StParm("RateVal",
                                                 ThetaStParm = Theta("tvRateVal")))))

# Using a character string (will be converted to Expression internally)
dp3 <- Dosepoint(DosepointName = "Bolus",
                 bioavail = "SystemicF") # Converted to Expression("SystemicF")

}
\seealso{
\code{\link[=list_Dosepoints]{list_Dosepoints()}}, \code{\link[=add_Dosepoint]{add_Dosepoint()}}, \code{\link[=modify_Dosepoint]{modify_Dosepoint()}}, \code{\link[=StParm]{StParm()}}, \code{\link[=Expression]{Expression()}}

Functions used for Dosepoint specification: 
\code{\link{add_Dosepoint}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_Dosepoint}()}
}
\concept{Dosepoints}
