% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred2df.R
\name{pred2df}
\alias{pred2df}
\title{Convert predictions to data.frame
Return predictions as data.frame}
\usage{
pred2df(x)
}
\arguments{
\item{x}{results of prediction as produced by \code{\link{predict.cancergram_model}}}
}
\value{
a data.frame with two columns and number of rows corresponding to the
number of peptides/proteins in the results of prediction. Columns contain following
information:
\describe{
  \item{seq_name}{Name of an analyzed sequence.}
  \item{acp}{Probability that a protein/peptide possesses anticancer activity.}
  \item{amp}{Probability that a protein/peptide possesses antimicrobial activity.}
  \item{neg}{Probability that a protein/peptide do not possesses anticancer 
  or antimicrobial activity.}
  \item{decision}{Result of the prediction.}
  }
}
\description{
Convert predictions to data.frame
Return predictions as data.frame
}
\examples{
data(CancerGram_predictions)
pred2df(CancerGram_predictions)
}
