% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_season.R
\name{find_season}
\alias{find_season}
\title{Find Sample's Season (Wet or Dry)}
\usage{
find_season(wet_season_start_dates, sampling_dates, wet_season_length = 182)
}
\arguments{
\item{wet_season_start_dates}{A vector of dates signifying the first day
of the wet season for site year combinations.}

\item{sampling_dates}{A date vector of sampling dates.
Must be in yyyy-mm-dd format.}

\item{wet_season_length}{The length of the wet season in days.}
}
\value{
A character vector
}
\description{
Find Sample's Season (Wet or Dry)
}
\examples{
dates <- as.Date(c("2014-12-04", "2014-10-30", "2015-11-12"))
wet_start_dates <- as.Date(c("2014-10-04", "2014-12-30", "2015-09-12"))
Seasons <- find_season(wet_start_dates, sampling_dates = dates)
#cut of date for the sampling year will be last day of June
}
