% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probihgcovn.R
\name{probihgcovn}
\alias{probihgcovn}
\title{Probability distribution of an IHG model with covariates}
\usage{
probihgcovn(m,ordinal,U,nu)
}
\arguments{
\item{m}{Number of ordinal categories}

\item{ordinal}{Vector of ordinal responses}

\item{U}{Matrix of selected covariates for explaining the preference parameter}

\item{nu}{Vector of coefficients for covariates, whose length equals NCOL(U)+1 to include
an intercept term in the model (first entry)}
}
\description{
Given a vector of \eqn{n} ratings over \eqn{m} categories, it returns a vector
of length \eqn{n} whose i-th element is the  probability of observing the i-th rating for the
corresponding IHG model with parameter \eqn{\theta_i}, obtained via logistic link with covariates
and coefficients.
}
\details{
The matrix \eqn{U} is expanded with a vector with entries equal to 1 in the first column to include
an intercept term in the model.
}
\examples{
n<-100
m<-7
theta<-0.30
ordinal<-simihg(n,m,theta)
U<-sample(c(0,1),n,replace=TRUE)
nu<-c(0.12,-0.5)
pr<-probihgcovn(m,ordinal,U,nu)
}
\seealso{
\code{\link{probihg}}
}
\keyword{distribution}
