% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CST_BindDim.R
\name{CST_BindDim}
\alias{CST_BindDim}
\title{Bind two objects of class s2dv_cube}
\usage{
CST_BindDim(x, along, var_dim = NULL, dat_dim = NULL)
}
\arguments{
\item{x}{Two or more objects of class \code{s2dv_cube} to be bound together.}

\item{along}{A character string indicating the name of the binding dimension.}

\item{var_dim}{A character string indicating the name of the variable
dimension. The default value is NULL. Specifying this dimension ensures}

\item{dat_dim}{A character string indicating the name of dataset dimension.
The default value is NULL. Specifying this dimension ensures the dataset
metadata is correctly preserved.}
}
\value{
An object of class \code{s2dv_cube} with the combined data, 
 dimensions, coordinates and attributes of the elements in \code{x}.
}
\description{
This function combines the data inside two or more objects of class
\code{s2dv_cube} along the specified \code{along} dimension, and modifies the
dimensions, coordinates and attributes accordingly, producing a result that
contains the complete metadata for all variables, time steps and spatial
coordinates that are bound in the process. It ensures that the information
inside the s2dv_cube remains coherent with the data it contains.\cr\cr
If the dimension specified in \code{along} is among the time dimensions in
\code{attrs$Dates}, the dates arrays are also bound along this dimension. 
The \code{load_parameters} and \code{when} attributes of the first cube
are preserved. The \code{source_files} attribute is bound along the
\code{var_dim} and \code{dat_dim} dimensions.
}
\examples{
 # Example with sample data:
 # Check original dimensions and coordinates
 lonlat_temp$exp$dims
 lonlat_temp$obs$dims
 # Bind both datasets along the member dimension
 res <- CST_BindDim(x = list(lonlat_temp$exp, lonlat_temp$obs),
                    along = "member",
                    var_dim = NULL,
                    dat_dim = "dat")
 # Check new dimensions and coordinates
 res$dims
 names(res$coords)

}
\seealso{
\link[abind]{abind}
}
\author{
Agudetse Roures Victoria, \email{victoria.agudetse@bsc.es}
}
