.check_coords <- function(lat1, lon1, lat2, lon2) {
  if (identical(as.numeric(lat1), as.numeric(lat2)) & identical(as.numeric(lon1), as.numeric(lon2))) {
    match <- TRUE
  } else {
    match <- FALSE
  }
  return(match)
}

# reorder dims to a reference array. If they do not exist, they are created
# example
#arr_ref <- array(NA, c(dataset = 1, sdate = 8, member = 3, ftime = 1, lon = 269, lat = 181))
#arr_to_reorder <- array(NA, c(dataset = 1, member = 3, sdate = 8, lat = 181, lon = 269, pp = 1))

.reorder_dims <- function(arr_ref, arr_to_reorder) {
   
  miss_dims <- names(dim(arr_ref))[!(names(dim(arr_ref)) %in% names(dim(arr_to_reorder)))]
 
  if (length(miss_dims) != 0) { 
    for (m in seq(miss_dims)) {
      arr_to_reorder <- InsertDim(data = arr_to_reorder, posdim = length(dim(arr_to_reorder)) + 1, lendim = 1,
                                  name = miss_dims[m])
    }
  }

  # TODO: add code to reorder dimensions and put the non-common dimensions at the end

  orddim <- match(names(dim(arr_ref)),names(dim(arr_to_reorder)))
  return(Reorder(data = arr_to_reorder, order = orddim))
}

#.check_coords <- function(lat1, lon1, lat2, lon2) {
#  match <- TRUE
#  if (!((length(lat1) == length(lat2)) & (length(lon1) == length(lon2)))) {
#    match <- FALSE
#  }
#  return(match)
#}


.KnownLonNames <- function() {
  known_lon_names <- c('lon', 'longitude', 'x', 'i', 'nav_lon')
  return(known_lon_names)
}

.KnownLatNames <- function() {
  known_lat_names <- c('lat', 'latitude', 'y', 'j', 'nav_lat')
  return(known_lat_names)
}


.warning <- function(...) {
  # Function to use the 'warning' R function with our custom settings
  # Default: no call information, indent to 0, exdent to 3, 
  #  collapse to \n
  args <- list(...)
  
  ## In case we need to specify warning arguments
  if (!is.null(args[["call."]])) {
    call <- args[["call."]]
  } else {
    ## Default: don't show info about the call where the warning came up
    call <- FALSE
  }
  if (!is.null(args[["immediate."]])) {
    immediate <- args[["immediate."]]
  } else {
    ## Default value in warning function
    immediate <- FALSE
  }
  if (!is.null(args[["noBreaks."]])) {
    noBreaks <- args[["noBreaks."]]
  } else {
    ## Default value warning function
    noBreaks <- FALSE
  }
  if (!is.null(args[["domain"]])) {
    domain <- args[["domain"]]
  } else {
    ## Default value warning function
    domain <- NULL
  }
  args[["call."]] <- NULL
  args[["immediate."]] <- NULL
  args[["noBreaks."]] <- NULL
  args[["domain"]] <- NULL
  
  ## To modify strwrap indent and exdent arguments
  if (!is.null(args[["indent"]])) {
    indent <- args[["indent"]]
  } else {
    indent <- 0
  }
  if (!is.null(args[["exdent"]])) {
    exdent <- args[["exdent"]]
  } else {
    exdent <- 3
  }
  args[["indent"]] <- NULL
  args[["exdent"]] <- NULL
  
  ## To modify paste collapse argument
  if (!is.null(args[["collapse"]])) {
    collapse <- args[["collapse"]]
  } else {
    collapse <- "\n!"
  }
  args[["collapse"]] <- NULL
  
  ## Warning tag
  if (!is.null(args[["tag"]])) {
    tag <- args[["tag"]]
  } else {
    tag <- "! Warning: "
  }
  args[["tag"]] <- NULL
  
  tmp <- paste0(tag, 
                paste(strwrap(args, indent = indent, exdent = exdent), collapse = collapse))
  warning(tmp, call. = call, immediate. = immediate, 
          noBreaks. = noBreaks, domain = domain)
}



