% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp_unif.R
\name{AHP.Unif}
\alias{AHP.Unif}
\title{Probabilistic AHP using Uniform distributions}
\usage{
AHP.Unif(n, list)
}
\arguments{
\item{n}{Random numbers created from Uniform distributions, using the parameters 'min' and 'max' of each pair-wise criteria comparison elicited from the experts.}

\item{list}{Pair-wise comparison matrices of expert opinions. The function 'list' is embedded in R.}
}
\value{
Weights returned from a simulation of AHP with Uniform distributions. The weights are driven from the simulated matrix that gives the minimum AHP Consistent Index.
}
\description{
This function computes criteria weights, using AHP and randomic pair-wise evaluations by Uniform distributions.
}
\examples{
n=5000 # Simulation
# Expert pair-wise evaluations
Exp.1 = matrix(c(1,0.2,0.3,5,1,0.2,3,5,1),3,3)
Exp.2 = matrix(c(1,2,8,0.5,1,6,0.12,0.16,1),3,3)
Exp.3 = matrix(c(1,0.5,0.5,2,1,6,2,0.16,1),3,3)
Exp.4 = matrix(c(1,3,4,0.3,1,0.5,0.25,0.3,1),3,3)
Exp.5 = matrix(c(1,4,5,0.25,1,1,0.2,1,1),3,3)
list = list(Exp.1,Exp.2,Exp.3,Exp.4,Exp.5)
AHP.Unif(n,list)
}
\references{
Saaty, Thomas L. (1980). The analytic hierarchy process: planning, priority setting, resource allocation, McGraw-Hill.
}
