% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{n_minmax}
\alias{n_minmax}
\title{Minmax a vector}
\usage{
n_minmax(x, l_u = c(0, 100))
}
\arguments{
\item{x}{A numeric vector}

\item{l_u}{A vector \code{c(l, u)}, where \code{l} is the lower bound and \code{u} is the upper bound. \code{x} will
be scaled exactly onto this interval.}
}
\value{
Normalised vector
}
\description{
Scales a vector using min-max method.
}
\details{
This function also supports parameter specification in \code{iMeta} for the \code{\link[=Normalise.coin]{Normalise.coin()}} method.
To do this, add columns \code{minmax_lower}, and \code{minmax_upper} to the \code{iMeta} table, which specify the
lower and upper bounds to scale each indicator to. Then set \code{f_n_para = "use_iMeta"} within the
\code{global_specs} list. See also examples in the \href{https://bluefoxr.github.io/COINr/articles/normalise.html}{normalisation vignette}.
}
\examples{
x <- runif(20)
n_minmax(x)

}
