% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treat.R
\name{log_CT_plus}
\alias{log_CT_plus}
\title{Log transform a vector (skew corrected)}
\usage{
log_CT_plus(x, na.rm = FALSE)
}
\arguments{
\item{x}{A numeric vector}

\item{na.rm}{Set \code{TRUE} to remove \code{NA} values, otherwise returns \code{NA}.}
}
\value{
A log-transformed vector of data, and treatment details wrapped in a list.
}
\description{
Performs a log transform on a numeric vector, but with consideration for the direction of the skew. The aim
here is to reduce the absolute value of skew, regardless of its direction.
}
\details{
Specifically:

If the skew of \code{x} is positive, this performs a modified "COIN Tool log" transform: \code{log(x-min(x) + a)}, where
\code{a <- 0.01*(max(x)-min(x))}.

If the skew of \code{x} is negative, it performs an equivalent transformation \code{-log(xmax + a - x)}.
}
\examples{
x <- runif(20)
log_CT(x)

}
