% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_coins_corr}
\alias{compare_coins_corr}
\title{Compare two coins by correlation}
\usage{
compare_coins_corr(coin1, coin2, dset, iCodes, compare_by = "ranks")
}
\arguments{
\item{coin1}{A coin}

\item{coin2}{A coin, with possibly alternative methodology. This should share at
least two units in common with \code{coin1}.}

\item{dset}{Target data set, must be present in both \code{coin1} and \code{coin2}}

\item{iCodes}{Character vector of indicator codes to correlate between the two
coins.}

\item{compare_by}{Either \code{"Ranks"} or \code{"Scores"}.}
}
\value{
A list containing a correlation table and a list of comparison data frames.
}
\description{
Given two coins, this function returns the correlation between the two coins,
for target datset \code{dset} and target indicator code(s) \code{iCodes}. Correlation
is calculated as the Pearson correlation coefficient, but if \code{compare_by = "Ranks"}
then this is the correlation coefficient of the ranks, which amounts to the
Spearman rank correlation. Set \code{compare_by = "Scores"} to return the Pearson
correlation between scores.
}
\examples{
# build example
coin <- build_example_coin()

# copy coin
coin2 <- coin

# change to prank function (percentile ranks)
# we don't need to specify any additional parameters (f_n_para) here
coin2$Log$Normalise$global_specs <- list(f_n = "n_prank")

# regenerate
coin2 <- Regen(coin2)

# iCodes to compare: all at level 3 and 4
iCodes <- coin$Meta$Ind$iCode[which(coin$Meta$Ind$Level > 2)]

# compare index, sort by absolute rank difference
l_comp <- compare_coins_corr(coin, coin2, dset = "Aggregated", iCodes = iCodes)

# see df
l_comp$df_corr

}
