% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitModels.R
\name{fitModels}
\alias{fitModels}
\title{fitModels}
\usage{
fitModels(
  CN_features,
  max_comps = NULL,
  min_comps = NULL,
  cores = 1,
  pR = FALSE,
  min_prior = NULL,
  featsToModel = CNSigs::defaultFeats
)
}
\arguments{
\item{CN_features}{List of features received from extractCopynumberFeatures}

\item{max_comps}{vector of length 6 specifying the max number of components 
for each feature. default is 10 for all features}

\item{min_comps}{vector of length 6 specifying the min number of components 
for each feature. default is 2 for all features}

\item{cores}{Number of parallel cores to use. Default is 1.}

\item{pR}{Peak Reduction reduces peaks in modeling to make modeling easier. Default is FALSE.}

\item{min_prior}{Used to override the minimum prior probabilty of a cluster}

\item{featsToModel}{The names of the features to extract.}
}
\value{
Returns a list of the different components that contain flexmix 
objects for each feature
}
\description{
This function takes all of the extracted copy number features and attempts to
fit a mixture of poisson and normal distributions to the data, and returns
a mixture of components that can be used to build the signatures. The order 
of features is "segsize","bp10MB","osCN","changepoint","copynumber","bpchrarm".
Therefore if you only want to change the maximum number of components for 
osCN to 5 then you would use max_comps = c(10,10,5,10,10,10).
}
\examples{
\donttest{
fitModels(featsExp)}

#Models an exact number of components, useful when comparing two different
#datasets
min_comps = c(7, 3, 3, 2, 2, 3)
max_comps = c(7, 3, 3, 2, 10, 3)
fitModels(featsExp, max_comps, min_comps)
}
\keyword{components}
\keyword{mixed}
\keyword{models}
