% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findExposures.R
\name{findExposures}
\alias{findExposures}
\title{findExposures}
\usage{
findExposures(scm, fixedSigs, runName = "", saveRes = FALSE, saveDir = NULL)
}
\arguments{
\item{scm}{Sample by component matrix}

\item{fixedSigs}{The fixed signatures}

\item{runName}{Name of the run used in file names, Default is ""}

\item{saveRes}{Whether or not to save the results, Default is FALSE}

\item{saveDir}{Where to save the results, must be provided if using saveDir}
}
\value{
Returns the resulting matrix of exposures
}
\description{
This function is used to find the signature exposures of a set of samples
using fixed signatures found earlier. It does this using the least squares
optimization method with constraints to keep the output as non-negative 
using the lsei function from the package limSolve.
}
\examples{
findExposures(t(scmExp), sigsExp)
}
\keyword{fixed}
\keyword{lsei}
\keyword{signatures}
