% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cin_metrics.R
\name{taiModified}
\alias{taiModified}
\title{Modified Total Aberration Index}
\usage{
taiModified(cnvData, segmentMean = 0, numProbes = NA)
}
\arguments{
\item{cnvData}{dataframe containing following columns: Sample, Start, End, Num_Probes, Segment_Mean}

\item{segmentMean}{numerical value for the minimum segment_mean cutoff/ threshold. Default is 0.2}

\item{numProbes}{Number of Probes}
}
\value{
Average of lengths weighted by segmentation mean for each unique sample
}
\description{
Modified Total Aberration Index calculation takes the sum of lengths of each segment
times its segmentation mean for each sample and divides it by the sum of the
lengths of each sample.
}
\details{
Modified Total Aberration Index uses all sample values instead of those in aberrant copy number state, thus does not remove the directionality from the score.
\deqn{
Modified\ Total\ Aberration\ Index =
\frac
{\sum^{R}_{i = 1} {d_i} \cdot {\bar{y}_{S_i}}}
{\sum^{R}_{i = 1} {d_i}}
}
}
\examples{
taiModified(cnvData = maskCNV_BRCA)
}
\seealso{
\code{\link{tai}}
}
