% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cin_metrics.R
\name{countingBaseSegments}
\alias{countingBaseSegments}
\title{countingBaseSegments}
\usage{
countingBaseSegments(cnvData, segmentMean = 0.2, numProbes = NA)
}
\arguments{
\item{cnvData}{dataframe containing following columns: Sample, Start, End, Num_Probes, Segment_Mean}

\item{segmentMean}{numerical value for the minimum segment_mean cutoff/ threshold. Default is 0.2}

\item{numProbes}{Number of Probes}
}
\value{
Number of Base segments for each unique sample
}
\description{
Function for counting altered base segments
}
\details{
The Altered Base Segment calculation takes all the CNV data for a single patient and first filters it for a segmentation mean of > 0.2 and, if specified, the minimum number of probes
covering that area. Then, it calculates the sums of the lengths of each segment for a particular patient and outputs that.
\deqn{
Number\ of\ Altered\ Bases = \sum^{R}_{i = 1} d_i\ where\ |\bar{y}_{S_i}| \ge 0.2
}
}
\examples{
countingBaseSegments(cnvData = maskCNV_BRCA)
}
