% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{local_bridging_centrality}
\alias{local_bridging_centrality}
\title{Local Bridging Centrality}
\usage{
local_bridging_centrality(x, vids = V(x))
}
\arguments{
\item{x}{An igraph or a network object.}

\item{vids}{Nodes to be considered in the calculation.}
}
\value{
A numeric vector including the centrality values for each node.
The centrality values represent the Local Bridging Centrality measure for each node in the network.
}
\description{
This function computes the Local Bridging Centrality for nodes in a network. The Local Bridging Centrality classifies nodes based on their structural links among the dense components.
}
\examples{

data(zachary)

local_bridging_centrality(zachary)

}
\references{
Macker, J.P. (2016). An improved local bridging centrality model for distributed network analytics. In Military Communications Conference, MILCOM 2016-2016 IEEE (pp. 600-605). IEEE. DOI: 10.1109/MILCOM.2016.7795393
}
\seealso{
\code{\link[igraph]{betweenness}}
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
