% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{dangalchev_closeness_centrality}
\alias{dangalchev_closeness_centrality}
\title{Dangalchev Closeness Centrality}
\usage{
dangalchev_closeness_centrality(
  x,
  vids = V(x),
  mode = c("all", "out", "in"),
  weights = NULL
)
}
\arguments{
\item{x}{An igraph or a network object.}

\item{vids}{Nodes to be considered in the calculation.}

\item{mode}{A character value indicating whether the shortest paths "in" or "out" of the nodes in directed graphs should be considered. For undirected graphs, use "all".}

\item{weights}{A numeric vector indicating the weights of the edges.}
}
\value{
A numeric vector including the centrality values for each node.
The centrality values represent the Dangalchev Closeness Centrality measure for each node in the network.
}
\description{
This function computes the Dangalchev Closeness Centrality for nodes in a network.
The Dangalchev Closeness Centrality measures closeness by removing nodes and edges, allowing for easier evaluation and handling of unconnected graphs.
}
\examples{

data(zachary)

dangalchev_closeness_centrality(zachary)

}
\references{
Dangalchev, C. (2006). Residual closeness in networks. Physica A: Statistical Mechanics and its Applications, 365, 556-564. DOI: 10.1016/j.physa.2005.12.020
}
\seealso{
\code{\link[centiserve]{closeness.residual}}
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
