#' OD matrix, male, 2008-2013.
#'
#' 4x4 origin-destination migration data matrix, male, 2008-2013, Chile.
#'
#' @format A data frame of 4 rows by 4 columns containing a 3x3
#' origin-destination migration data matrix for males, including counts for
#' the non-migrant population in the diagonal. The first row and column
#' correspond to the area names. Rows correspond to destinations and columns represent
#' origins.
#' \describe{
#'   \item{Greater.Santiago}{Population, male}
#'   \item{Rest.of.the.Metropolitan.region}{Population, male}
#'   \item{Rest.of.the.country}{Population, male}
#' }
#' @source \url{https://www.tandfonline.com/doi/suppl/10.1080/00324728.2017.1416155?scroll=top}
"male"

#' OD matrix, female, 2008-2013.
#'
#' 4x4 origin-destination migration data matrix, female, 2008-2013, Chile.
#'
#' @format A data frame of 4 rows by 4 columns containing a 3x3
#' origin-destination migration data matrix for females, including counts for
#' the non-migrant population in the diagonal. The first row and column
#' correspond to the area names. Rows correspond to destinations and columns represent
#' origins.
#' \describe{
#'   \item{Greater.Santiago}{Population, female}
#'   \item{Rest.of.the.Metropolitan.region}{Population, female}
#'   \item{Rest.of.the.country}{Population, female}
#' }
#' @source \url{https://www.tandfonline.com/doi/suppl/10.1080/00324728.2017.1416155?scroll=top}
"female"

#' OD matrix, people aged 1-14, 2010-2011.
#'
#' 34x34 origin-destination migration data matrix, population aged 1-14, 2010-2011, UK.
#'
#' @format A data frame of 34 rows by 34 columns containing a 33x33
#' origin-destination migration data matrix for people aged 1-14, including counts for
#' the non-migrant population in the diagonal. The first row and column
#' correspond to the area names. Rows correspond to destinations and columns represent
#' origins.
#' \describe{
#'   \item{Barking and Dagenham}{Population, aged 1 to 14}
#'   \item{Barnet}{Population, aged 1 to 14}
#'   \item{Bexley}{Population, aged 1 to 14}
#'   \item{Brent}{Population, aged 1 to 14}
#'   \item{Bromley}{Population, aged 1 to 14}
#'   \item{Camden}{Population, aged 1 to 14}
#'   \item{Croydon}{Population, aged 1 to 14}
#'   \item{Ealing}{Population, aged 1 to 14}
#'   \item{Enfield}{Population, aged 1 to 14}
#'   \item{Greenwich}{Population, aged 1 to 14}
#'   \item{Hackney}{Population, aged 1 to 14}
#'   \item{Hammersmith and Fulham}{Population, aged 1 to 14}
#'   \item{Haringey}{Population, aged 1 to 14}
#'   \item{Harrow}{Population, aged 1 to 14}
#'   \item{Havering}{Population, aged 1 to 14}
#'   \item{Hillingdon}{Population, aged 1 to 14}
#'   \item{Hounslow}{Population, aged 1 to 14}
#'   \item{Islington}{Population, aged 1 to 14}
#'   \item{Kensington and Chelsea}{Population, aged 1 to 14}
#'   \item{Kingston upon Thames}{Population, aged 1 to 14}
#'   \item{Lambeth}{Population, aged 1 to 14}
#'   \item{Lewisham}{Population, aged 1 to 14}
#'   \item{Merton}{Population, aged 1 to 14}
#'   \item{Newham}{Population, aged 1 to 14}
#'   \item{Redbridge}{Population, aged 1 to 14}
#'   \item{Richmond upon Thames}{Population, aged 1 to 14}
#'   \item{Southwark}{Population, aged 1 to 14}
#'   \item{Sutton}{Population, aged 1 to 14}
#'   \item{Tower Hamlets}{Population, aged 1 to 14}
#'   \item{Waltham Forest}{Population, aged 1 to 14}
#'   \item{Wandsworth}{Population, aged 1 to 14}
#'   \item{City of London-Westminster}{Population, aged 1 to 14}
#'   \item{Rest of the UK}{Population, aged 1 to 14}
#' }
#' @source {2011 Census for England and Wales}
"pop1_14"

#' OD matrix, people aged 15-29, 2010-2011.
#'
#' 34x34 origin-destination migration data matrix, population aged 15-29, 2010-2011, UK.
#'
#' @format A data frame of 34 rows by 34 columns containing a 33x33
#' origin-destination migration data matrix for people aged 15-29, including counts for
#' the non-migrant population in the diagonal. The first row and column
#' correspond to the area names. Rows correspond to destinations and columns represent
#' origins.
#' \describe{
#'   \item{Barking and Dagenham}{Population, aged 15 to 29}
#'   \item{Barnet}{Population, aged 15 to 29}
#'   \item{Bexley}{Population, aged 15 to 29}
#'   \item{Brent}{Population, aged 15 to 29}
#'   \item{Bromley}{Population, aged 15 to 29}
#'   \item{Camden}{Population, aged 15 to 29}
#'   \item{Croydon}{Population, aged 15 to 29}
#'   \item{Ealing}{Population, aged 15 to 29}
#'   \item{Enfield}{Population, aged 15 to 29}
#'   \item{Greenwich}{Population, aged 15 to 29}
#'   \item{Hackney}{Population, aged 15 to 29}
#'   \item{Hammersmith and Fulham}{Population, aged 15 to 29}
#'   \item{Haringey}{Population, aged 15 to 29}
#'   \item{Harrow}{Population, aged 15 to 29}
#'   \item{Havering}{Population, aged 15 to 29}
#'   \item{Hillingdon}{Population, aged 15 to 29}
#'   \item{Hounslow}{Population, aged 15 to 29}
#'   \item{Islington}{Population, aged 15 to 29}
#'   \item{Kensington and Chelsea}{Population, aged 15 to 29}
#'   \item{Kingston upon Thames}{Population, aged 15 to 29}
#'   \item{Lambeth}{Population, aged 15 to 29}
#'   \item{Lewisham}{Population, aged 15 to 29}
#'   \item{Merton}{Population, aged 15 to 29}
#'   \item{Newham}{Population, aged 15 to 29}
#'   \item{Redbridge}{Population, aged 15 to 29}
#'   \item{Richmond upon Thames}{Population, aged 15 to 29}
#'   \item{Southwark}{Population, aged 15 to 29}
#'   \item{Sutton}{Population, aged 15 to 29}
#'   \item{Tower Hamlets}{Population, aged 15 to 29}
#'   \item{Waltham Forest}{Population, aged 15 to 29}
#'   \item{Wandsworth}{Population, aged 15 to 29}
#'   \item{City of London-Westminster}{Population, aged 15 to 29}
#'   \item{Rest of the UK}{Population, aged 15 to 29}
#' }
#' @source {2011 Census for England and Wales}
"pop15_29"

#' OD matrix, people aged 30-34, 2010-2011.
#'
#' 34x34 origin-destination migration data matrix, population aged 30-34, 2010-2011, UK.
#'
#' @format A data frame of 34 rows by 34 columns containing a 33x33
#' origin-destination migration data matrix for people aged 30-34, including counts for
#' the non-migrant population in the diagonal. The first row and column
#' correspond to the area names. Rows correspond to destinations and columns represent
#' origins.
#' \describe{
#'   \item{Barking and Dagenham}{Population, aged 30 to 44}
#'   \item{Barnet}{Population, aged 30 to 44}
#'   \item{Bexley}{Population, aged 30 to 44}
#'   \item{Brent}{Population, aged 30 to 44}
#'   \item{Bromley}{Population, aged 30 to 44}
#'   \item{Camden}{Population, aged 30 to 44}
#'   \item{Croydon}{Population, aged 30 to 44}
#'   \item{Ealing}{Population, aged 30 to 44}
#'   \item{Enfield}{Population, aged 30 to 44}
#'   \item{Greenwich}{Population, aged 30 to 44}
#'   \item{Hackney}{Population, aged 30 to 44}
#'   \item{Hammersmith and Fulham}{Population, aged 30 to 44}
#'   \item{Haringey}{Population, aged 30 to 44}
#'   \item{Harrow}{Population, aged 30 to 44}
#'   \item{Havering}{Population, aged 30 to 44}
#'   \item{Hillingdon}{Population, aged 30 to 44}
#'   \item{Hounslow}{Population, aged 30 to 44}
#'   \item{Islington}{Population, aged 30 to 44}
#'   \item{Kensington and Chelsea}{Population, aged 30 to 44}
#'   \item{Kingston upon Thames}{Population, aged 30 to 44}
#'   \item{Lambeth}{Population, aged 30 to 44}
#'   \item{Lewisham}{Population, aged 30 to 44}
#'   \item{Merton}{Population, aged 30 to 44}
#'   \item{Newham}{Population, aged 30 to 44}
#'   \item{Redbridge}{Population, aged 30 to 44}
#'   \item{Richmond upon Thames}{Population, aged 30 to 44}
#'   \item{Southwark}{Population, aged 30 to 44}
#'   \item{Sutton}{Population, aged 30 to 44}
#'   \item{Tower Hamlets}{Population, aged 30 to 44}
#'   \item{Waltham Forest}{Population, aged 30 to 44}
#'   \item{Wandsworth}{Population, aged 30 to 44}
#'   \item{City of London-Westminster}{Population, aged 30 to 44}
#'   \item{Rest of the UK}{Population, aged 30 to 44}
#' }
#' @source {2011 Census for England and Wales}
"pop30_44"

#' OD matrix, people aged 45-64, 2010-2011.
#'
#' 34x34 origin-destination migration data matrix, population aged 45-64, 2010-2011, UK.
#'
#' @format A data frame of 34 rows by 34 columns containing a 33x33
#' origin-destination migration data matrix for people aged 45-64, including counts for
#' the non-migrant population in the diagonal. The first row and column
#' correspond to the area names. Rows correspond to destinations and columns represent
#' origins.
#' \describe{
#'   \item{Barking and Dagenham}{Population, aged 45 to 64}
#'   \item{Barnet}{Population, aged 45 to 64}
#'   \item{Bexley}{Population, aged 45 to 64}
#'   \item{Brent}{Population, aged 45 to 64}
#'   \item{Bromley}{Population, aged 45 to 64}
#'   \item{Camden}{Population, aged 45 to 64}
#'   \item{Croydon}{Population, aged 45 to 64}
#'   \item{Ealing}{Population, aged 45 to 64}
#'   \item{Enfield}{Population, aged 45 to 64}
#'   \item{Greenwich}{Population, aged 45 to 64}
#'   \item{Hackney}{Population, aged 45 to 64}
#'   \item{Hammersmith and Fulham}{Population, aged 45 to 64}
#'   \item{Haringey}{Population, aged 45 to 64}
#'   \item{Harrow}{Population, aged 45 to 64}
#'   \item{Havering}{Population, aged 45 to 64}
#'   \item{Hillingdon}{Population, aged 45 to 64}
#'   \item{Hounslow}{Population, aged 45 to 64}
#'   \item{Islington}{Population, aged 45 to 64}
#'   \item{Kensington and Chelsea}{Population, aged 45 to 64}
#'   \item{Kingston upon Thames}{Population, aged 45 to 64}
#'   \item{Lambeth}{Population, aged 45 to 64}
#'   \item{Lewisham}{Population, aged 45 to 64}
#'   \item{Merton}{Population, aged 45 to 64}
#'   \item{Newham}{Population, aged 45 to 64}
#'   \item{Redbridge}{Population, aged 45 to 64}
#'   \item{Richmond upon Thames}{Population, aged 45 to 64}
#'   \item{Southwark}{Population, aged 45 to 64}
#'   \item{Sutton}{Population, aged 45 to 64}
#'   \item{Tower Hamlets}{Population, aged 45 to 64}
#'   \item{Waltham Forest}{Population, aged 45 to 64}
#'   \item{Wandsworth}{Population, aged 45 to 64}
#'   \item{City of London-Westminster}{Population, aged 45 to 64}
#'   \item{Rest of the UK}{Population, aged 45 to 64}
#' }
#' @source {2011 Census for England and Wales}
"pop45_64"

#' OD matrix, people aged 65+, 2010-2011.
#'
#' 34x34 origin-destination migration data matrix, population aged 65+, 2010-2011, UK..
#'
#' @format A data frame of 34 rows by 34 columns containing a 33x33
#' origin-destination migration data matrix for people aged 65+, including counts for
#' the non-migrant population in the diagonal. The first row and column
#' correspond to the area names. Rows correspond to destinations and columns represent
#' origins.
#' \describe{
#'   \item{Barking and Dagenham}{Population, aged  65 plus}
#'   \item{Barnet}{Population, aged  65 plus}
#'   \item{Bexley}{Population, aged  65 plus}
#'   \item{Brent}{Population, aged  65 plus}
#'   \item{Bromley}{Population, aged  65 plus}
#'   \item{Camden}{Population, aged  65 plus}
#'   \item{Croydon}{Population, aged  65 plus}
#'   \item{Ealing}{Population, aged  65 plus}
#'   \item{Enfield}{Population, aged  65 plus}
#'   \item{Greenwich}{Population, aged  65 plus}
#'   \item{Hackney}{Population, aged  65 plus}
#'   \item{Hammersmith and Fulham}{Population, aged  65 plus}
#'   \item{Haringey}{Population, aged  65 plus}
#'   \item{Harrow}{Population, aged  65 plus}
#'   \item{Havering}{Population, aged  65 plus}
#'   \item{Hillingdon}{Population, aged  65 plus}
#'   \item{Hounslow}{Population, aged  65 plus}
#'   \item{Islington}{Population, aged  65 plus}
#'   \item{Kensington and Chelsea}{Population, aged  65 plus}
#'   \item{Kingston upon Thames}{Population, aged  65 plus}
#'   \item{Lambeth}{Population, aged  65 plus}
#'   \item{Lewisham}{Population, aged  65 plus}
#'   \item{Merton}{Population, aged  65 plus}
#'   \item{Newham}{Population, aged  65 plus}
#'   \item{Redbridge}{Population, aged  65 plus}
#'   \item{Richmond upon Thames}{Population, aged  65 plus}
#'   \item{Southwark}{Population, aged  65 plus}
#'   \item{Sutton}{Population, aged  65 plus}
#'   \item{Tower Hamlets}{Population, aged  65 plus}
#'   \item{Waltham Forest}{Population, aged  65 plus}
#'   \item{Wandsworth}{Population, aged  65 plus}
#'   \item{City of London-Westminster}{Population, aged  65 plus}
#'   \item{Rest of the UK}{Population, aged  65 plus}
#' }
#' @source {2011 Census, England and Wales}
"pop65over"

