\name{summary.feasible}
\alias{summary.feasible}
\title{Summarize a \code{feasible} object}
\description{
Displays the full summary of an object returned by \code{\link{feasible}}. 
}
\usage{
\method{summary}{feasible}(object, ...)
}
\arguments{
  \item{object}{An object of class \code{"feasible"} as returned by \code{\link{feasible}}.}
  \item{\dots}{Unused; included for S3 method compatibility.}
}
\details{
The method extracts the data frame stored in the \code{"summary"} attribute of the \code{feasible} object. 
This data frame contains (at least) the following columns:
\itemize{
  \item \code{time}: Time index \code{t}.
  \item \code{Strategy}: Index of the intervention strategy.
  \item \code{Abar}: The target intervention value at time \code{t}.
  \item \code{Feasible}: Mean of the mapped feasible values for the targeted bin.
  \item \code{\%infeasible}: Proportion of observations falling below the estimated density threshold for the given \code{Abar} as targeted.
}
If the \code{"summary"} attribute is \code{NULL}, the method prints \dQuote{No summary available.}
}
\value{
A data frame containing the summary if available; otherwise \code{NULL}.
}
\seealso{
\code{\link{feasible}}, \code{\link{plot.feasible}}
}

\keyword{summary}