#' CHOIR Body Map data for approximately 7,000 patients
#'
#' A non-identifiable, simulated data set generated by randomly permuting
#' data from the CHOIR Body Map validation study.
#'
#' @docType data
#'
#' @usage data(validation)
#'
#' @format An object of class \code{"data.frame"}
#' \describe{
#'  \item{id}{A randomly generated numeric code for each patient.}
#'  \item{gender}{The patient's gender.}
#'  \item{race}{The patient's race.}
#'  \item{age}{The patient's age.}
#'  \item{bodymap_regions_csv}{The patient's CHOIR Body Map in a comma
#'  separated string.}
#'  \item{score}{A simulated pain score for demonstration purposes.}
#' }
#'
#' @references This data set was derived from the data collected during the
#' study validating the CHOIR Body Map as an instrument for recording a
#' patient's anatomical pain location.
#' \doi{10.1097/pr9.0000000000000880}
#'
#' @keywords datasets
#' @examples
#'
#' data(validation)
#' head(validation)
#'
"validation"
