% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PooledStPD.R
\name{PooledStPD}
\alias{PooledStPD}
\title{Pooled Strip Plot Design Analysis}
\usage{
PooledStPD(
  data,
  Response,
  Location,
  Replication,
  RowFactor,
  ColumnFactor,
  alpha,
  Mult_Comp_Test
)
}
\arguments{
\item{data}{A data frame containing the experimental data.}

\item{Response}{A numeric variable representing the dependent variable (response).}

\item{Location}{A factor indicating different locations or years.}

\item{Replication}{A factor indicating replications.}

\item{RowFactor}{A factor used for horizontal strips.}

\item{ColumnFactor}{A factor used for vertical strips.}

\item{alpha}{A numeric value specifying the significance level for Bartlett’s test.}

\item{Mult_Comp_Test}{An integer specifying the type of multiple comparison test:
\itemize{
  \item 1 = Tukey's honestly significant difference (Tukey's HSD) test
  \item 2 = Duncan's multiple range test (DMRT)
  \item 3 = least significant difference (LSD) test
}}
}
\value{
A list containing the following components:
\itemize{
  \item \strong{Individual_ANOVA}: Summary of ANOVA results for each location or year.
  \item \strong{Location_wise}: Multiple comparisons of interaction of RowFactor and ColumnFactor within each location or year.
  \item \strong{Bartlett_Test}: Results of Bartlett's test for homogeneity of variances.
  \item \strong{Pooled_ANOVA}: Combined (pooled) ANOVA table across all locations or years.
  \item \strong{Interaction_Comparison}: Summary of pooled interaction of RowFactor and ColumnFactor comparisons using the selected multiple comparison test..
}
}
\description{
This function conducts a pooled analysis of variance (ANOVA) using the strip plot design (StPD) for data collected across multiple locations or years. In this design, the interaction between factors (RowFactor and ColumnFactor) is estimated with higher precision. For more details see Dean et al. (2017)<doi:10.1007/978-3-319-52250-0> and Ruíz et al. (2024)<doi:10.1007/978-3-031-65575-3>.
}
\examples{
# Creating a sample dataset for Pooled Strip Plot Design (StPD)
df <- data.frame(
  Location = factor(rep(c("Londan", "Agumbe"), each = 12)),  # Locations
  Replication = factor(rep(c(1, 2), each = 6, times = 2)),  # Replications
  RowFactor = factor(rep(c(1, 2), each = 3, times = 4)),  # Row factor
  ColumnFactor = factor(rep(1:3, times = 8)),  # Column factor
  Yield = c(4940, 4810, 5150, 4900, 4920, 5070, 
            4830, 5110, 4920, 5020, 5110, 5230,
            4964, 4997, 5011, 5102, 4858, 4888, 
            5100, 5165, 4965, 5113, 5086, 5176)  # Yield values
)

# Running PooledStPD function on the dataset
out <- PooledStPD(df, "Yield", "Location", "Replication", "RowFactor", "ColumnFactor", 0.05, 1)

# Print results
print(out)
}
\references{
Dean A, Voss D, Draguljic D (2017)<doi:10.1007/978-3-319-52250-0>.

Ruíz JS, López OAM, Crossa J (2024)<doi:10.1007/978-3-031-65575-3>.
}
