% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Identify_Markers.R
\name{Identify_Markers}
\alias{Identify_Markers}
\title{Identify markers of each cluster}
\usage{
Identify_Markers(
  Seurat_object,
  PowerCutoff = 0.4,
  DifferenceCutoff = 0,
  PvalueCutoff = 0.05
)
}
\arguments{
\item{Seurat_object}{Seurat object, should contain cluster information}

\item{PowerCutoff}{numeric, indicating the cutoff of gene power to refine marker genes}

\item{DifferenceCutoff}{numeric, indicating the cutoff of difference in marker genes between
clusters to refine marker genes}

\item{PvalueCutoff}{numeric, indicating the p.value cutoff of chi-square test to refine marker genes}
}
\value{
Data frame of conserved markers
}
\description{
This function first identify marker genes in each cluster
with Roc threshold > RocThr. Then, based on marker genes identified above,
this function calculates the difference and power of marker genes in each
cluster, and marker genes with Difference threshold > DiffThr will be retained.
Next, gene with the largest power in which cluster will be the marker
gene in this cluster. Eventually, make fisher test for power of each cluster,
cluster with p.value < 0.05 will be retained as the final cluster for marker gene
}
\examples{
data("pbmc_small")
all.markers <- Identify_Markers(pbmc_small)
}
