% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{BRISE_Rank}
\alias{BRISE_Rank}
\title{Rank Induction within- and cross-pattern similarity blocks}
\usage{
BRISE_Rank(S, method = "row")
}
\arguments{
\item{S}{Numeric similarity matrix: (Sii) (square) when \code{method = "row"}; (Sij) (rectangular) when
\code{method = "rowij"}. Larger values indicate greater similarity.}

\item{method}{Character, either \code{"row"} (within-pattern (Sii), diagonal suppressed) or \code{"rowij"}
(cross-pattern (Sij), no diagonal to suppress).}
}
\value{
A numeric matrix with the same dimensions as \code{S} containing row-wise ranks minus one.
}
\description{
Compute row-wise ranks of a similarity matrix for two cases:
\itemize{
  \item \code{method = "row"}: within-pattern block (Sii) (square). Because self-pairs exist, the diagonal
        (self-similarity) is first forced below the minimum entry of (S) so that self-neighbors are always ranked last
        and thus excluded when top-(k) truncation is applied downstream.
  \item \code{method = "rowij"}: cross-pattern block (Sij) (rectangular, i!=j). There are no self-pairs,
        so no diagonal adjustment is needed.
}
Ranks are computed row-wise with \code{rank()} and then shifted by 1 (i.e., the function returns \code{rank - 1}).
}
\keyword{internal}
