% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_partitioning.R
\name{.perform_partitioning}
\alias{.perform_partitioning}
\title{Return the group number for each localization.}
\usage{
.perform_partitioning(
  input,
  critDist,
  use_prog_bar = TRUE,
  run_parallel = FALSE,
  num_cores = NULL,
  partition_req = 5000,
  parallel_call_depth = 3,
  min_gap = NULL
)
}
\arguments{
\item{input}{A numeric matrix where each row is a localization and each
column is a spatial axis.}

\item{critDist}{The critical distance for which localizations nearer than
this distance are deemed part of the same group.}

\item{use_prog_bar}{TRUE/FALSE indicating whether a progress bar should be
used. This is only available when run_parallel is FALSE.}

\item{run_parallel}{TRUE/FALSE indicating whether operations should be
performed in parallel. This is only valid if partitioning is performed.}

\item{num_cores}{The number of cores to use if running in parallel.}

\item{partition_req}{The minimum number of points required to create a new
partition.}

\item{parallel_call_depth}{The number of levels of partitioning that should
be performed before terminating calls to run operations in parallel. The
number of threads opened when running in parallel is equal to
2^(parallel_call_depth)*num_cores.}

\item{min_gap}{The minimum width of any dimension created during
partitioning.}
}
\description{
Group PALM/iPALM localizations based on their physical separation distance
}
\details{
PALM/iPALM data results in a list of spatial coordinates for fluorophore
localizations. This function groups nearby localizations if they are within
the provided critical distance from each other.
}
\author{
Zach Colburn
}
