% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.r
\name{save_biothermr}
\alias{save_biothermr}
\title{Save BioThermR Data Objects to Disk}
\usage{
save_biothermr(img_input, file_path)
}
\arguments{
\item{img_input}{A single 'BioThermR' class object or a list of 'BioThermR' objects
(e.g., the output from \code{read_thermal_batch}).}

\item{file_path}{String. The destination path (e.g., "results/obj.rds").
If the directory structure does not exist, it will be created automatically.}
}
\value{
None (invisible \code{NULL}). Prints a success message to the console upon completion.
}
\description{
Serializes and saves a single 'BioThermR' object or a list of objects to a compressed
             .rds file. This ensures that all components—raw temperature matrices, processed
             masks, metadata, and calculation stats—are preserved accurately.
}
\examples{
\donttest{
# Load data
mat <- matrix(runif(160*120, 20, 40), nrow = 120, ncol = 160)
obj <- create_BioThermR(mat, name = "Simulation_01")

# Save a single object to a temporary directory
out_file <- file.path(tempdir(), "mouse_01.rds")
save_biothermr(obj, out_file)
}
}
