% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.r
\name{plot_thermal_cloud}
\alias{plot_thermal_cloud}
\title{Generate a "Thermal Cloud" Visualization (Phyllotaxis Layout)}
\usage{
plot_thermal_cloud(
  img_list,
  spread_factor = 1.1,
  jitter_factor = 0.5,
  palette = "inferno",
  text_color = "black",
  text_size = 3,
  show_labels = TRUE
)
}
\arguments{
\item{img_list}{A list of 'BioThermR' objects. For best results, these should be pre-processed
(e.g., background removed via \code{\link{roi_filter_threshold}}).}

\item{spread_factor}{Numeric. Multiplier for the distance between objects.
Values > 1.0 increase spacing (airier cloud), values < 1.0 pack objects tighter. Default is 1.1.}

\item{jitter_factor}{Numeric. Introduces random noise to the placement coordinates to break perfect symmetry
and create a more natural look. Default is 0.5.}

\item{palette}{String. The color palette from the 'viridis' package. Default is "inferno".}

\item{text_color}{String. Color of the filename labels. Default is "black".}

\item{text_size}{Integer. Font size for the labels. Default is 3.}

\item{show_labels}{Logical. If \code{TRUE}, displays the filename below each object. Default is \code{TRUE}.}
}
\value{
A \code{ggplot} object with a white background and void theme.
}
\description{
Arranges a collection of segmented thermal objects into an organic, spiral "cloud" formation.
             Unlike a rigid grid, this layout uses a golden-angle spiral (phyllotaxis) algorithm to cluster
             subjects efficiently. This is particularly effective for visualizing the diversity of thermal
             phenotypes in large datasets or creating artistic figures for presentations and covers.
}
\details{
The function performs object-centric rendering:
         \enumerate{
           \item \strong{Extraction:} For each image, it extracts only the valid foreground pixels (non-NA),
                 ignoring the original frame dimensions.
           \item \strong{Re-centering:} Each object is mathematically centered at (0,0) relative to its own coordinate system.
           \item \strong{Placement:} Objects are placed along a spiral path defined by the Golden Angle (~137.5 degrees).
         }
         The spacing and randomness of the spiral can be tuned using \code{spread_factor} and \code{jitter_factor}.
}
\examples{
\donttest{
# Load a batch of images
img_obj_list <- system.file("extdata",package = "BioThermR")
batch <- read_thermal_batch(img_obj_list)
batch <- lapply(batch, roi_segment_ebimage)

# Create an artistic thermal cloud
p_cloud <- plot_thermal_cloud(batch, spread_factor = 1.5, jitter_factor = 2.0)
}
}
