% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratios.R
\name{resist.ratio}
\alias{resist.ratio}
\title{Calculate lethal dosage, resistance ratios, and regression coefficients
 and tests for linearity}
\usage{
resist.ratio(
  data,
  conf.level = 0.95,
  LD.value = c(25, 50, 95),
  ref.strain = NULL,
  plot = FALSE,
  plot.conf = TRUE,
  test.validity = TRUE,
  legend.par = c("bottomright"),
  ...
)
}
\arguments{
\item{data}{a data frame of probit-transformed mortality data using the
function probit.trans()}

\item{conf.level}{numerical. level for confidence intervals to be applied
to the models (default 0.95)}

\item{LD.value}{numerical. Level of lethal dose to be tested.
default=c(25,50,95)}

\item{ref.strain}{character. name of the reference strain if present
(see details)}

\item{plot}{logical. Whether to draw the plot. Default FALSE}

\item{plot.conf}{logical. If plot=TRUE, whether to plot the 95 percent
confidence intervals. Default TRUE}

\item{test.validity}{logical. If plot=TRUE (default), the regression for a
strain that failed the linearity test is not plotted}

\item{legend.par}{arguments to be passed on to \code{legend()} as
in \code{mort.plot()}}

\item{...}{parameters to be passed on to graphics for the plot
(e.g. col, pch)}
}
\value{
Returns a data frame with the various estimates mentioned above.
 If plot=TRUE, plots the mortality on a probit-transformed scale against
 the log_10 doses.
}
\description{
Using a generalized linear model (GLM, logit link function), this function
computes the lethal doses for 25%, 50% and 95% (unless otherwise provided)
of the population (LD25, LD50 and LD95, resp.), and their confidence
intervals (LDmax and LDmin, 0.95 by default). See details for more info.
}
\details{
If a name is provided in ref.strain=, it will be used as the
reference to compute the resistance ratios (RR). Alternatively, the
function will look for a strain with the suffix "-ref" in the dataset.
If this returns NULL, the strain with the lowest LD50 will be considered as reference.

In addition to LD values, the function in a nutshell uses a script modified
from Johnson et al (2013), which allows taking the g factor into account
("With almost all good sets of data, g will be substantially smaller than
1.0 and seldom greater than 0.4." Finney, 1971) and the heterogeneity (h)
of the data (Finney, 1971) to calculate the confidence intervals (i.e. a
larger heterogeneity will increase the confidence intervals). It also
computes the corresponding resistance ratios (RR), i.e. the ratios between
a given strain and the strain with the lower LD50 and LD95, respectively for
 RR50 and RR95 (usually, it is the susceptible reference strain), with their
 95% confidence intervals (RRmin and RRmax), calculated according to
 Robertson and Preisler (1992). Finally, it also computes the coefficients
  (slope and intercept, with their standard error) of the linear
  regressions) and tests for the linearity of the dose-mortality response
  using a chi-square test (Chi(p)) between the observed dead numbers (data)
  and the dead numbers predicted by the regression (the test is significant
  if the data is not linear, e.g. mixed populations).
}
\examples{
data(bioassay)
transd<-probit.trans(bioassay$assay2)
data<-transd$tr.data
resist.ratio(data,plot=TRUE)

}
\references{
Finney DJ (1971). Probitanalysis. Cambridge:Cambridge
University Press. 350p.

Hommel G (1988). A stage wise rejective multiple test procedure based on
a modified Bonferroni test. Biometrika 75, 383-6.

Johnson RM, Dahlgren L, Siegfried BD, Ellis MD (2013). Acaricide,fungicide
and drug interactions in honeybees (Apis mellifera). PLoSONE8(1): e54092.

Robertson, J. L., and H.K. Preisler.1992. Pesticide bioassays with
arthropods. CRC, Boca Raton, FL.
}
\author{
Pascal Milesi, Piyal Karunarathne, Pierrick Labbé
}
