\name{print.BinaryEPPM}
\alias{print.BinaryEPPM}
\title{
Printing of BinaryEPPM Objects
}
\description{
Prints objects of class "BinaryEPPM".
}
\usage{
\method{print}{BinaryEPPM}(x, digits = max(3, getOption("digits") - 3), \dots)
}
\arguments{
  \item{x}{
fitted model object of class "BinaryEPPM".
}
  \item{digits}{
digits of printed output.
}
  \item{\dots}{
not currently used.
}
}
\references{
Cribari-Neto F, Zeileis A. (2010). Beta Regression in R.
\emph{Journal of Statistical Software}, \bold{34}(2), 1-24. \doi{10.18637/jss.v034.i02}.
}
\author{
David M. Smith <dmccsmith@verizon.net>
}
\value{An object of class "BinaryEPPM" is constructed. This object has the following attributes.
  \item{data.type}{
Indicator of the type of data either 0 "data.frame" or 1 "list".
}
  \item{list.data}{
Regardless of the "data.type", the data in list form.
}
  \item{call}{
The "call" to the function "BinaryEPPM".
}
  \item{formula}{
The model formula in "call".
}
  \item{model.type}{
The model type in "call".
}
  \item{model.name}{
The model name in "call".
}
  \item{link}{
The link function in "call".
}
  \item{covariates.matrix.p}{
The matrix of covariates for the model for p.
}
  \item{covariates.matrix.scalef}{
The matrix of covariates for the model for scale-factor.
}
  \item{offset.p}{
The vector of offsets for the model for p.
}
  \item{offset.scalef}{
The vector of offsets for the model for scale-factor.
}
  \item{coefficients}{
The coefficients of the fitted model.
}
  \item{loglik}{
The log-likelihood of the fitted model.
}
  \item{vcov}{
The variance-covariance matrix of the fitted model.
}
  \item{n}{
The number of observations. Relabelled duplication of "nobs" needed when calling function "lrtest". 
}
  \item{nobs}{
The number of observations.
}
  \item{df.null}{
The degrees of freedom of the null model.
}
  \item{df.residual}{
The degrees of freedom of the residual model.
}
  \item{vnmax}{
Vector of number of "trials" in each observation.
}
  \item{weights}{
Vector of weights for observation.
}
  \item{converged}{
Indicator of convergence.
}
  \item{method}{
Method used to calculate pseudo.r.squared.
}
  \item{pseudo.r.squared}{
The value of the coefficient of determination r squared.
}
  \item{start}{
Initial estimates.
}
  \item{optim}{
Final model fit.
}
  \item{control}{
Control parameters for optimization function "optim".
}
  \item{fitted.values}{
The fitted values.
}
  \item{y}{
The dependent variable in the model.
}
  \item{terms}{
The terms in the model.
}
}
\seealso{
\code{\link[betareg]{betareg}} 
}
\examples{
data("ropespores.case") 
BinaryEPPM(data = ropespores.case,
           number.spores / number.tested ~ 1 + offset(logdilution),
           model.type = 'p only', model.name = 'binomial')   
}
\keyword{ IO }