% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ftrf.R
\name{ftrf}
\alias{ftrf}
\title{Generalized logit transform}
\usage{
ftrf(x, xl, xu)
}
\arguments{
\item{x}{a numeric vector}

\item{xl}{a numeric vector of same length as x with x > xl}

\item{xu}{a numeric vector of same length as x with x < xu}
}
\value{
returns numerical vector of transforms
}
\description{
maps a bounded parameter x onto the real line according to
y=log((x-xl)/(xu-x))), with xl < x < xu. If this constraint is violated, an
error occurs. x may be vector
}
\seealso{
\code{\link{btrf}}
}
\author{
E. Georg Luebeck (FHCRC)
}
\keyword{misc}
\keyword{optimize}
