% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriorparameters.R
\name{DAGparameters}
\alias{DAGparameters}
\title{Augment a DAG with parameters}
\usage{
DAGparameters(incidence, dataParams, unrollDBN = TRUE)
}
\arguments{
\item{incidence}{a single adjacency matrix with entry [i,j] equal to 1 
when a directed edge exists from node i to node j}

\item{dataParams}{the data and parameters used to learn the DAGs derived from the
\code{\link[BiDAG]{scoreparameters}} function of the BiDAG package}

\item{unrollDBN}{logical indicating whether to unroll a DBN to a full DAG over
all time slices (TRUE, default) or to use the compact representation (FALSE)}
}
\value{
the DAG and a list of parameters for each node given
its parents
}
\description{
\code{DAGparameters} takes a DAG and augments it with parameters.
For binary data these are the parameters of the posterior beta
distributions and its mean. For continuous data, these are parameters 
of the posterior distributions of the edge coefficients from arXiv:2010.00684.
There is support for user-defined augmentation, with the caveat that it
must match the output format of either the binary or continuous cases.
}
\examples{

scoreParam <- BiDAG::scoreparameters("bde", BiDAG::Asia)
AsiaParam <- DAGparameters(BiDAG::Asiamat, scoreParam)

}
