/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.inference.operators.factorAnalysis.LoadingsSamplerConstraints;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class GeneralizedSampleConstraints
implements LoadingsSamplerConstraints {
    private final ArrayList<int[]> columnIndices;
    private final ArrayList<Integer> uniqueLengths;
    private final int[] arrayIndices;
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private static final String SAMPLE_COLUMNS = "sampleColumns";
        private static final String INDICES = "indices";
        private static final String TRAITS = "traits";
        private static final String ROWS = "rows";

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            int n = 1;
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                XMLObject xMLObject2 = (XMLObject)xMLObject.getChild(i);
                int[] nArray = xMLObject2.getIntegerArrayAttribute(TRAITS);
                int[] nArray2 = xMLObject2.getIntegerArrayAttribute(ROWS);
                for (int n2 : nArray) {
                    if (n2 != n) {
                        throw new XMLParseException("Currently only implemented for sequential 'traits' values.");
                    }
                    int n3 = 0;
                    while (n3 < nArray2.length) {
                        int n4 = n3++;
                        nArray2[n4] = nArray2[n4] - 1;
                    }
                    arrayList.add(nArray2);
                    ++n;
                }
            }
            return new GeneralizedSampleConstraints(arrayList);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(INDICES, new XMLSyntaxRule[]{AttributeRule.newIntegerArrayRule(TRAITS, false), AttributeRule.newIntegerArrayRule(ROWS, false)}, 1, Integer.MAX_VALUE)};
        }

        @Override
        public String getParserDescription() {
            return "Sample from only certain elements of the loadings matrix";
        }

        @Override
        public Class getReturnType() {
            return LoadingsSamplerConstraints.class;
        }

        @Override
        public String getParserName() {
            return SAMPLE_COLUMNS;
        }
    };

    GeneralizedSampleConstraints(ArrayList<int[]> arrayList) {
        this.columnIndices = arrayList;
        int n = arrayList.size();
        this.uniqueLengths = new ArrayList();
        this.arrayIndices = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = arrayList.get(i).length;
            int n3 = -1;
            for (int j = 0; j < this.uniqueLengths.size(); ++j) {
                if (this.uniqueLengths.get(j) != n2) continue;
                n3 = j;
                break;
            }
            if (n3 == -1) {
                n3 = this.uniqueLengths.size();
                this.uniqueLengths.add(n2);
            }
            this.arrayIndices[i] = n3;
        }
    }

    @Override
    public int getColumnDim(int n, int n2) {
        return this.columnIndices.get(n).length;
    }

    @Override
    public int getArrayIndex(int n, int n2) {
        return this.arrayIndices[n];
    }

    @Override
    public void allocateStorage(ArrayList<double[][]> arrayList, ArrayList<double[]> arrayList2, ArrayList<double[]> arrayList3, int n) {
        for (int i = 0; i < this.uniqueLengths.size(); ++i) {
            int n2 = this.uniqueLengths.get(i);
            arrayList.add(new double[n2][n2]);
            arrayList2.add(new double[n2]);
            arrayList3.add(new double[n2]);
        }
    }
}

