% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wishart.R
\name{bi.dist.wishart}
\alias{bi.dist.wishart}
\title{Wishart distribution for covariance matrices.}
\usage{
bi.dist.wishart(
  concentration,
  scale_matrix = py_none(),
  rate_matrix = py_none(),
  scale_tril = py_none(),
  validate_args = py_none(),
  name = "x",
  obs = py_none(),
  mask = py_none(),
  sample = FALSE,
  seed = py_none(),
  shape = c(),
  event = 0,
  create_obj = FALSE,
  to_jax = TRUE
)
}
\arguments{
\item{concentration}{A positive concentration parameter analogous to the
concentration of a Gamma distribution. The concentration must be larger
than the dimensionality of the scale matrix.}

\item{scale_matrix}{A scale matrix analogous to the inverse rate of a Gamma
distribution.}

\item{rate_matrix}{A rate matrix anaologous to the rate of a Gamma
distribution.}

\item{scale_tril}{Cholesky decomposition of the `scale_matrix`.}

\item{validate_args}{Logical: Whether to validate parameter values.  Defaults to `reticulate::py_none()`.}

\item{name}{A character string representing the name of the random variable
within a model. This is used to uniquely identify the variable. Defaults to 'x'.}

\item{obs}{A numeric vector or array of observed values. If provided, the
random variable is conditioned on these values. If `NULL`, the variable is
treated as a latent (unobserved) variable. Defaults to `NULL`.}

\item{mask}{An optional boolean array to mask observations.}

\item{sample}{A logical value that controls the function's behavior. If `TRUE`,
the function will directly draw samples from the distribution. If `FALSE`,
it will create a random variable within a model. Defaults to `FALSE`.}

\item{seed}{An integer used to set the random seed for reproducibility when
`sample = TRUE`. This argument has no effect when `sample = FALSE`, as
randomness is handled by the model's inference engine. Defaults to 0.}

\item{shape}{A numeric vector specifying the shape. When `sample=False`
(model building), this is used with `.expand(shape)` to set the
distribution's batch shape. When `sample=True` (direct sampling), this is
used as `sample_shape` to draw a raw JAX array of the given shape.}

\item{event}{The number of batch dimensions to reinterpret as event dimensions
(used in model building).}

\item{create_obj}{If `TRUE`, returns the raw BI distribution object
instead of creating a sample site. This is essential for building complex
distributions like `MixtureSameFamily`.}

\item{to_jax}{Boolean. Indicates whether to return a JAX array or not.}
}
\value{
- When \code{sample=FALSE}, a BI Wishart distribution object (for model building).

 - When \code{sample=TRUE}, a JAX array of samples drawn from the Wishart distribution (for direct sampling).

 - When \code{create_obj=TRUE}, the raw BI distribution object (for advanced use cases).
}
\description{
The Wishart distribution is a multivariate distribution used to model positive definite matrices,
often representing covariance matrices. It's commonly used in Bayesian statistics and machine learning,
particularly in models involving covariance estimation.
}
\examples{
\donttest{
library(BayesianInference)
m=importBI(platform='cpu')
bi.dist.wishart(concentration = 5, scale_matrix = matrix(c(1,0,0,1), nrow = 2), sample = TRUE)
}
}
\seealso{
\url{https://num.pyro.ai/en/stable/distributions.html#wishart}
}
