% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{posterior_dirichlet}
\alias{posterior_dirichlet}
\title{Dirichlet-conjugate posterior (analytical mean)}
\usage{
posterior_dirichlet(P, LT, gamma = 0.1)
}
\arguments{
\item{P}{Prior matrix (\eqn{T \times K}); filas no negativas que suman 1 (o cercanas).}

\item{LT}{Likelihood matrix (\eqn{T \times K}); filas no negativas que suman 1 (o cercanas).}

\item{gamma}{Positive uncertainty factor (default \code{0.1}); menor \eqn{\gamma}
implica mayor concentración (más “seguro”).}
}
\value{
Posterior matrix \eqn{W} (\eqn{T \times K}), filas suman 1.
}
\description{
Interpreta \eqn{P} y \eqn{LT} como proporciones convertidas a pseudo-cuentas
con concentración total \eqn{\alpha_{base}=1/\gamma}. El posterior medio es
\eqn{W = (P\,\alpha_{base} + LT\,\alpha_{base}) / \mathrm{rowSums}(\cdot)}.
}
\examples{
T <- 6; K <- 3
P  <- matrix(runif(T*K), T);  P  <- P  / rowSums(P)
LT <- matrix(runif(T*K), T); LT <- LT / rowSums(LT)
W <- posterior_dirichlet(P, LT, gamma = 0.1)

}
\seealso{
\code{\link{posterior_weighted}}, \code{\link{posterior_multiplicative}},
  \code{\link{posterior_adaptive}}
}
