% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdTOST.R
\name{porsTOST}
\alias{porsTOST}
\title{Probability of replication success based on TOST equivalence}
\usage{
porsTOST(level, dprior, margin, sr)
}
\arguments{
\item{level}{Significance level for the TOST p-value}

\item{dprior}{Design prior object}

\item{margin}{The equivalence margin > 0 for the equivalence region around
zero that defines a region of practically irrelevant effect sizes}

\item{sr}{Replication standard error}
}
\value{
The probability to achieve replication success
}
\description{
This function computes the probability to achieve replication
    success based on establishing the absence of a practically relevant
    effect size with the Two One-Sided Tests (TOST) procedure in
    the replication study.
}
\examples{
## specify design prior
to1 <- 2
so1 <- 0.05
dprior <- designPrior(to = to1, so = so1, tau = 0.1)
porsTOST(level = 0.1, dprior = dprior, margin = 0.3, sr = c(0.05, 0.03))

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}

Anderson, S. F. and Maxwell, S. E. (2016). There's more than one way to
conduct a replication study: Beyond statistical significance. Psychological
Methods, 21(1), 1-12. \doi{10.1037/met0000051}
}
\author{
Samuel Pawel
}
