% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastGPfit.R
\name{GP.simulate.curve.fast}
\alias{GP.simulate.curve.fast}
\title{Simulate curve on d-dimensional Euclidean space based on Gaussian
processes via modified exponential squared kernel.}
\usage{
GP.simulate.curve.fast(
  x,
  poly_degree,
  a,
  b,
  center = NULL,
  scale = NULL,
  max_range = 6
)
}
\arguments{
\item{x}{A matrix of real numbers as grid points where rows are observations and columns are coordinates.}

\item{poly_degree}{A integer number to specify the highest degree of Hermite polynomials. The default value is 10L.}

\item{a}{A positive real number to specify the concentration parameter in the standard modified exponential squared kernel. The larger value the more the GP concentrates around the center. The default value is 0.01.}

\item{b}{A positive real number to specify the smoothness parameter in the standard modified exponential squared kernel. The smaller value the smoother the GP is. The default value is 1.0.}

\item{center}{A vector of real numbers specifying the centroid parameters in the modified exponential squared kernel. The default value is NULL and set to the center of the grid points: apply(x,2,mean).}

\item{scale}{A vector of positive numbers specifying the scale parameters in the modified exponential squared kernel. The default value is NULL and set to values such that grid points in a range of (-max_range,max_range) in each dimension.}

\item{max_range}{A positive real number indicating the maximum range of the grid points to specify the scale parameter. The default value is NULL and set to 6.}
}
\value{
A list of variables representing the simulated curve:
\describe{
 \item{f}{A vector of real numbers for the simulated curve.}
 \item{x}{A matrix of real numbers for the grid points where rows are observations and columns are coordinates.}
 \item{work_x}{A matrix of real numbers for the standardized grid points for the simulated curve. It has the same dimension as "x".}
}
}
\description{
Simulate curve on d-dimensional Euclidean space based on Gaussian
processes via modified exponential squared kernel.
}
\examples{
library(BayesGPfit)
library(lattice)
set.seed(1224)
dat = list()
dat$x = GP.generate.grids(d=2,num_grids = 100)
curve = GP.simulate.curve.fast(dat$x,a=0.01,b=0.5,poly_degree=20L)
GP.plot.curve(curve,main="Simulated Curve")
}
\author{
Jian Kang <jiankang@umich.edu>
}
