% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnbd.R
\name{pnbd.PlotDropoutRateHeterogeneity}
\alias{pnbd.PlotDropoutRateHeterogeneity}
\title{Pareto/NBD Plot Dropout Rate Heterogeneity}
\usage{
pnbd.PlotDropoutRateHeterogeneity(params, lim = NULL)
}
\arguments{
\item{params}{Pareto/NBD parameters - a vector with r, alpha, s, and beta, in
that order. r and alpha are unobserved parameters for the NBD transaction
process. s and beta are unobserved parameters for the Pareto (exponential
gamma) dropout process.}

\item{lim}{The upper-bound of the x-axis. A number is chosen by the function
if none is provided.}
}
\value{
Distribution of customers' propensities to drop out.
}
\description{
Plots and returns the estimated gamma distribution of mu (customers'
propensities to drop out).
}
\details{
This returns the distribution of each customer's exponential parameter that
determines their lifetime (using the Pareto/NBD assumption that a customer's
lifetime can be modeled with an exponential distribution).
}
\examples{
params <- c(0.55, 10.56, 0.61, 11.64)
pnbd.PlotDropoutRateHeterogeneity(params)
params <- c(0.55, 10.56, 3, 11.64)
pnbd.PlotDropoutRateHeterogeneity(params)
}
