% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bss_fit.R
\name{bssAlphaFit}
\alias{bssAlphaFit}
\title{Estimating the smoothness parameter of a Brownian semistationary process}
\usage{
bssAlphaFit(Y, p = 2)
}
\arguments{
\item{Y}{a vector of observations of a BSS process at any frequency.}

\item{p}{the power to be used in the change of frequency method. The default value is p = 2.}
}
\value{
The function returns a single value - an estimate for the smoothness parameter alpha.
}
\description{
\code{bssAlphaFit} uses the 'Change of Frequency' method to estimate the smoothness parameter, \code{alpha},
of a BSS process. The COF method needs only minimal assumptions on the parametric form of the kernel,
therefore the estimate can be used in any kernel.
}
\examples{

N <- 10000
n <- 100
T <- 1.0
theta <- 0.5
beta <- 0.125

kappa <- 3
alpha <- -0.2
lambda <- 1.0


vol <- exponentiatedOrnsteinUhlenbeck(N, n, T, theta, beta)
bss_simulation <- gammaKernelBSS(N, n, T, kappa, alpha, lambda, sigma = vol)
y <- bss_simulation$bss

bssAlphaFit(y, p = 2)

}
