% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blsm.R
\name{plot_traceplots_acf}
\alias{plot_traceplots_acf}
\title{BLSM traceplots and ACF}
\usage{
plot_traceplots_acf(blsm_obj, chosen_node = 1, coordinate = 1,
  chosen_pair = c(1, 2))
}
\arguments{
\item{blsm_obj}{BLSM object obtained through \link[BLSM]{estimate_latent_positions}}

\item{chosen_node}{Specified node for traceplot and autocorrelation function (Procrustean framework)}

\item{coordinate}{Specified coordinate dimension from the n-dimensional latent space}

\item{chosen_pair}{Specified pair of nodes for traceplot and autocorrelation function (non-Procrustean framework)}
}
\description{
Traceplots and autocorrelation functions for the \eqn{\alpha} variable and a selected node (or pair of nodes in the non-Procrustean framework).
}
\examples{
plot_traceplots_acf(example_blsm_obj, chosen_node=3, coordinate=1)

\dontrun{
 # Run the simulation without Procrustean step
 blsm_obj = estimate_latent_positions(example_adjacency_matrix, procrustean = FALSE, 
                          burn_in = 3*10^4, nscan = 10^5)
 
 # Plot 
 plot_traceplots_acf(blsm_obj, chosen_pair=c(2,5))
}
}
