% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blsm.R
\name{plot_latent_positions}
\alias{plot_latent_positions}
\title{Base BLSM plot function}
\usage{
plot_latent_positions(blsm_obj, colors, points_size = 0.1,
  labels_point_size = 5, labels_point_color = "yellow",
  labels_text_size = 1, labels_text_color = "blue", circles_2D = FALSE)
}
\arguments{
\item{blsm_obj}{BLSM object obtained through \link[BLSM]{estimate_latent_positions}}

\item{colors}{(Optional) Colors of the simulated coordinate points in the latent space. Internal default colors are used if the argument is missing.}

\item{points_size}{Size of the coordinate points}

\item{labels_point_size}{Size of the label points}

\item{labels_point_color}{Color of the label points}

\item{labels_text_size}{Text size in the label points}

\item{labels_text_color}{Text color in the label points}

\item{circles_2D}{Plot circles of radius \eqn{\alpha} (see the model's main variables) centered around the label points}
}
\description{
Plot latent positions from a Procrustean simulation.
}
\examples{
plot_latent_positions(example_blsm_obj, labels_point_color = "black", labels_text_color = "black")

plot_latent_positions(example_blsm_obj, circles_2D = TRUE)
}
