% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{alpha_up}
\alias{alpha_up}
\title{Update step for the \eqn{\alpha} variable}
\usage{
alpha_up(Y, lpz, W, alpha, adelta, a_a, a_b)
}
\arguments{
\item{Y}{Adjacency matrix of the observed network}

\item{lpz}{Matrix containing the negative square root of the Euclidean distances between latent positions}

\item{W}{BLSM Weights matrix of the observed network}

\item{alpha}{Model variable \eqn{\alpha}}

\item{adelta}{The uniform proposal for \eqn{\alpha} is defined on the \eqn{[-adelta,+adelta]} interval}

\item{a_a}{Shape parameter of the Gamma prior distribution for \eqn{\alpha}. The value is usually set to 1, so the prior is actually an exponential distribution.}

\item{a_b}{Rate parameter of the Gamma prior distribution for \eqn{\alpha}.}
}
\value{
Updated value of the \eqn{\alpha} variable
}
\description{
Accept/reject the proposal for the \eqn{\alpha} model variable
}
