% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ble_profiling.R
\name{ble_profile}
\alias{ble_profile}
\title{Likelihood profile for various measurement error values}
\usage{
ble_profile(data, sigh, model="lp", equation=NULL,  start, UpLo="U",
             optim.method="BFGS", plot=TRUE)
}
\arguments{
\item{data}{A dataframe with two numeric columns, independent (\code{x}) and
dependent (\code{y}) variables respectively.}

\item{sigh}{A vector of the suggested standard deviations of the measurement error
values.}

\item{model}{Selects the functional form of the boundary line. It includes
\code{"blm"} for linear model, \code{"lp"} for linear plateau model, \code{"mit"}
for the Mitscherlich model, \code{"schmidt"} for the Schmidt model,
\code{"logistic"} for logistic model, \code{"logisticND"} for logistic model
proposed by Nelder (1961), \code{"inv-logistic"} for the inverse logistic
model, \code{"double-logistic"} for the double logistic model, \code{"qd"} for
quadratic model and the \code{"trapezium"} for the trapezium model. For custom
models, set \code{model = "other"}.}

\item{equation}{A custom model function writen in the form of an R function. Applies
only when argument \code{model="other"}, else it is \code{NULL}.}

\item{start}{A numeric vector of initial starting values for optimization
  in fitting the boundary model. Its length and arrangement depend on the
  suggested model: \itemize{
  \item For the \code{"blm"} model, it is a vector of length 7 arranged as the
  intercept, the slope, mean of \code{x}, mean of \code{y}, standard deviation
  of \code{x}, standard deviation of \code{y} and the correlation of \code{x}
  and \code{y}.
  \item For the \code{"lp"} model, it is a vector of length 8 arranged as the
  intercept, the slope, the maximum or plateau response, mean of \code{x},
  mean of \code{y}, standard deviation of \code{x}, standard deviation of \code{y}
  and the correlation of \code{x} and \code{y}.
  \item For the \code{"mit"} model, it is a vector of length 8 arranged as the
  intercept, shape parameter, the maximum or plateau response, mean of \code{x},
  mean of \code{y}, standard deviation of \code{x}, standard deviation of \code{y}
  and the correlation of \code{x} and \code{y}.
  \item For the \code{"logistic"}, \code{"inv-logistic"} and \code{"logisticND"}
  models, it is a vector of length 8 arranged as scaling parameter, shape parameter,
  the maximum or plateau value, mean of \code{x}, mean of \code{y},
  standard deviation of \code{x}, standard deviation of \code{y} and the
  correlation of \code{x} and \code{y}.
  \item For the \code{"double-logistic"} model, it is a vector of length 11
  arranged as scaling parameter, shape parameter, maximum response, maximum response,
  scaling parameter two, shape parameter two, mean of \code{x}, mean of \code{y},
  standard deviation of \code{x}, standard deviation of \code{y} and the correlation
  of \code{x} and \code{y}.
  \item For the \code{"trapezium"} model, it is a vector of length 10 arranged
  as intercept one, slope one, maximum response, intercept two, slope two,
  mean of \code{x}, mean of \code{y}, standard deviation of \code{x},
  standard deviation of \code{y} and the correlation of \code{x} and \code{y}.
  \item For the \code{"qd"} model, it is a vector of length 8 arranged as a
  constant, linear coefficient, quadratic coefficient,mean of \code{x},
  mean of \code{y}, standard deviation of \code{x}, standard deviation of \code{y}
  and the correlation of \code{x} and \code{y}.
  \item For the \code{"schmidt"} model, it is a vector of length 8 arranged the
  scaling parameter, shape parameter (x-value at maximum response ),
  maximum response, mean of \code{x}, mean of \code{y}, standard deviation of
  \code{x}, standard deviation of \code{y} and the correlation of \code{x}
  and \code{y}.
}}

\item{UpLo}{Selects the type of boundary. \code{"U"} fits the upper boundary and
"L" fits the lower boundary.}

\item{optim.method}{Describes the method used to optimize the model as in the
\code{optim()} function. The methods include \code{"Nelder-Mead"}, \code{"BFGS"},
\code{"CG"}, \code{"L-BFGS-B"}, \code{"SANN"} and \code{"Brent"}.}

\item{plot}{If \code{TRUE}, a plot is part of the output. If \code{FALSE}, plot
is not part of output (default is \code{TRUE}).}
}
\value{
A list of length 2 containing the suggested standard deviations of
  measurement error values and the corresponding log-likelihood values.
  additionally, a likelihood profile plot (log-likelihood against the standard
  deviation of measurement error) is produced.
}
\description{
Estimates the standard deviation of measurement error (\code{sign}) of the response
variable, an input of the \code{cbvn()} function, when a measured value is not
available (Lark & Milne, 2016). \code{sigh} is fixed at each of a set of
values in turn, and remaining parameters are estimated conditional on \code{sigh}
by maximum likelihood. The maximized likelihoods for the sequence of values
constitutes a likelihood profile. The value of \code{sigh} where the profile
is maximized is selected.
}
\details{
Some inbuilt models are available for the \code{cbvn()} function. The suggest model
forms are as follows: \enumerate{
 \item Linear model (\code{"blm"})
 \deqn{y=\beta_1 + \beta_2x}
 where \eqn{\beta_1} is the intercept and \eqn{\beta_2} is the slope.

 \item Linear plateau model (\code{"lp"})
 \deqn{y= {\rm min}(\beta_1+\beta_2x, \beta_0)}
 where \eqn{\beta_1} is the intercept , \eqn{\beta_2} is the slope  and \eqn{\beta_0}
 is the maximum response.

 \item The logistic (\code{"logistic"}) and inverse logistic (\code{"inv-logistic"})
 models
 \deqn{ y= \frac{\beta_0}{1+e^{\beta_2(\beta_1-x)}}}
 \deqn{ y= \beta_0 - \frac{\beta_0}{1+e^{\beta_2(\beta_1-x)}}}
 where \eqn{\beta_1} is a scaling parameter , \eqn{\beta_2} is a shape parameter
 and \eqn{\beta_0} is the maximum response.

 \item Logistic model (\code{"logisticND"})  (Nelder (1961))
 \deqn{ y= \frac{\beta_0}{1+(\beta_1 \times e^{-\beta_2x})}}
  where \eqn{\beta_1} is a scaling parameter, \eqn{\beta_2} is a shape
  parameter and \eqn{\beta_0} is the maximum response.

 \item Double logistic model (\code{"double-logistic"})
 \deqn{ y= \frac{\beta_{0,1}}{1+e^{\beta_2(\beta_1-x)}} -
 \frac{\beta_{0,2}}{1+e^{\beta_4(\beta_3-x)}}}
 where \eqn{\beta_1} is a scaling parameter one, \eqn{\beta_2} is shape parameter one,
 \eqn{\beta_{0,1}} and \eqn{\beta_{0,2}} are the maximum response ,
 \eqn{\beta_3} is a scaling parameter two and  \eqn{\beta_4} is a shape parameter two.

 \item Quadratic model (\code{"qd"})
 \deqn{y=\beta_1 + \beta_2x + \beta_3x^2}
 where \eqn{\beta_1} is a constant, \eqn{\beta_2} is a linear coefficient
 and  \eqn{\beta_3} is the quadratic coefficient.

 \item Trapezium model (\code{"trapezium"})
 \deqn{y={\rm min}(\beta_1+\beta_2x, \beta_0, \beta_3 + \beta_4x)}
 where  \eqn{\beta_1} is the intercept one, \eqn{\beta_2} is the slope one,
 \eqn{\beta_0} is the maximum response, \eqn{\beta_3} is the intercept two
 and \eqn{\beta_3} is the slope two.

 \item Mitscherlich model (\code{"mit"})
 \deqn{y= \beta_0 - \beta_1*\beta_2^x}
 where \eqn{\beta_1} is the intercept, \eqn{\beta_2} is a shape parameter
 and \eqn{\beta_0} is the maximum response.

 \item Schmidt model (\code{"schmidt"})
 \deqn{y= \beta_0 + \beta_1(x-\beta_2)^2}
 where \eqn{\beta_1} is ascaling parameter, \eqn{\beta_2} is a
 shape parameter (x-value at maximum response ) and \eqn{\beta_0} is the
 maximum response .
 }

The function \code{ble_profile()} utilities the optimization procedure of the
\code{optim()} function to determine the model parameters. There is a tendency
for optimization algorithms to settle at a local optimum. To remove the risk of
settling for local optimum parameters, it is advised that the function is run
using several starting values and the results with the largest likelihood
can be taken as a representation of the global optimum.

The common errors encountered due to poor start values \enumerate{
\item function cannot be evaluated at initial parameters
\item initial value in 'vmmin' is not finite}
}
\examples{

x<-evapotranspiration$`ET(mm)`
y<-evapotranspiration$`yield(t/ha)`
data<-data.frame(x,y)
start<-c(0.5,0.02,289.6,2.4,83.7,1.07,0.287)
sigh <- c(0.6,0.7,0.8,0.9)

ble_profile(data,start=start,model = "blm", sigh = sigh)

}
\references{
Lark, R. M., & Milne, A. E. (2016). Boundary line analysis of the effect of water
filled pore space on nitrous oxide emission from cores of arable soil. European
Journal of Soil Science, 67 , 148-159.

Nelder, J.A. 1961. The fitting of a generalization of the logistic curve.
Biometrics 17: 89–110.
}
\author{
Chawezi Miti <chawezi.miti@nottingham.ac.uk>
}
