% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{bhai.barplot}
\alias{bhai.barplot}
\title{Barplot of cases, deaths and DALYs.}
\usage{
bhai.barplot(..., what, infections=NULL, cols1=NULL, cols2=NULL, ylab=NULL, ylim=NULL, 
legend_labs=NULL, main="", names.inf=TRUE, cex.names=1, border=par("fg"), lwd.errors=2)
}
\arguments{
\item{...}{Further plotting arguments}

\item{what}{One of c("Cases", "Deaths", "DALY")}

\item{infections}{If sepcified only a subset of infections in \code{bhai_summary} is plotted.}

\item{cols1}{Color used to fill the bars.}

\item{cols2}{Specifies colors of YLDs when plotting DALYs.}

\item{ylab}{Y-axis labels.}

\item{ylim}{Limits of y-axis.}

\item{legend_labs}{Labels of legend.}

\item{main}{Title of plot}

\item{names.inf}{Specifying whether names of infections should be plotted.}

\item{cex.names}{Font size of labels.}

\item{border}{The color to be used for the border of the bars, default: par("fg").}

\item{lwd.errors}{Line width of error bars.}
}
\description{
Barplot of cases, deaths and DALYs.
}
\examples{

data(german_pps_2011_repr)
german_pps_repr = PPS(num_hai_patients = num_hai_patients,
    num_hai_patients_by_stratum = num_hai_patients_by_stratum,
    num_hai_patients_by_stratum_prior = num_hai_patients_by_stratum_prior,
    num_survey_patients = num_survey_patients,
    length_of_stay = length_of_stay,
    loi_pps = loi_pps,
    mccabe_scores_distr = mccabe_scores_distr,
    mccabe_life_exp = mccabe_life_exp,
    hospital_discharges = hospital_discharges,
    population = population,
    country="Germany (representative sample)")
german_pps_repr

set.seed(3)
# The following example is run only for illustratory reasons
# Note that you should never run the function with only 10 Monte-Carlo simulations in practice!
result_ger = bhai(german_pps_repr, nsim=10)

bhai.barplot(result_ger, what="Cases")

}
\seealso{
\code{\linkS4class{PPS}}
}
