% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCuPlotDiag.R
\name{CCuPlotDiag}
\alias{CCuPlotDiag}
\title{Diagnostics plots for Lambda, Theta, Delta,
U, C, Pi, Z and Epsilon. Hazard function, cure proportion and cure time for the median observation.}
\usage{
CCuPlotDiag(M, variable = "Lambda", pos = 1)
}
\arguments{
\item{M}{tibble. Contains the output by
\code{CCuMRes}.}

\item{variable}{Either "Lambda", "U", "C", "Mu", "Pi", "Z" or "Epsilon".
Variable for which diagnostic plot will be shown.}

\item{pos}{Positive integer. Position of the selected \code{variable} to be
plotted.}
}
\description{
Diagnostic plots for hazard rate (Lambda), regression parameters for the
hazard (Theta), regression parameters for the cure rate (Delta), latent
variable (U), dependence parameter (C), mean of cure threshold (Mu), 
cure proportion (Pi), cure threshold (Z) and the
parameter of the hierarchical prior (Epsilon).
}
\details{
This function returns a diagnosyics plot for which the chain for the selected
variable can be monitored. Diagnostics includes trace, ergodic mean,
autocorrelation function and histogram.
}
\examples{



## Simulations may be time intensive. Be patient.

## Example 1
# data(BMTKleinbook)
# res <- CCuMRes(BMTKleinbook, covs.x = c("tTransplant","hodgkin","karnofsky","waiting"),
#                covs.y = c("tTransplant","hodgkin","karnofsky","waiting"),
#                        type.t = 2, K = 72, length = 30,
#                        alpha = rep(2,72), beta = rep(2,72), c.r = rep(50, 71), type.c = 2,
#                        var.delta.str = .1, var.theta.str = 1,
#                        var.delta.ini = 100, var.theta.ini = 100,
#                        iterations = 100, burn.in = 10, thinning = 1)
# CCuPlotDiag(M = res, variable = "Z")
# CCuPlotDiag(M = res, variable = "Pi.m")
# CCuPlotDiag(M = res, variable = "Lambda", pos = 2)
# CCuPlotDiag(M = res, variable = "U", pos = 4)




}
\references{
Nieto-Barajas, L. E., & Yin, G. (2008). Bayesian semiparametric
cure rate model with an unknown threshold. \emph{Scandinavian Journal of
Statistics}, \strong{35(3)}, 540-556.
https://doi.org/10.1111/j.1467-9469.2007.00589.x
}
\seealso{
\link{CCuMRes}
}
