% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.bandwidth}
\alias{kernel.bandwidth}
\title{Kernel bandwidth estimation by median heuristic method with bootstrap CI}
\usage{
kernel.bandwidth(
  comm,
  scale_data = FALSE,
  ci_type = "bca",
  runs = 1000,
  conf = 0.95,
  cores = 1
)
}
\arguments{
\item{comm}{A numeric matrix or data frame.}

\item{scale_data}{Logical; if \code{TRUE}, variables are centered and scaled
before distances are computed.}

\item{ci_type}{Character; passed to \code{\link[boot]{boot.ci}}.
One of \code{"norm"}, \code{"basic"}, \code{"stud"}, \code{"perc"}, or \code{"bca"}.}

\item{runs}{Integer; number of bootstrap resamples.}

\item{conf}{Confidence level for the CI (between 0 and 1).}

\item{cores}{Number of cores to be used in parallel processing. If = 0 all available cores are used.}
}
\value{
An object of class \code{sigma_bootstrap_result} containing:
\item{sigma_original}{Point estimate from the full data.}
\item{sigma_bootstrap}{Bootstrap mean estimate.}
\item{bootstrap_se}{Bootstrap standard error.}
\item{ci}{Confidence interval object from \code{boot.ci}.}
\item{bootstrap_distribution}{Vector of bootstrap values.}
\item{boot_object}{The full boot object from \code{boot()}.}
}
\description{
Computes the Gaussian-kernel (Radial Basis Function) bandwidth \eqn{\sigma}
using the median-heuristic (inverse of the median of squared Euclidean distances),
and returns a bootstrap confidence interval. This assumes the kernel is
parameterized as \eqn{k(x_i, x_j) = \exp(-\sigma ||x_i - x_j||^2)}.
}
\examples{
set.seed(1)
comm <- matrix(rexp(200, rate = 0.1), ncol = 4)
res <- kernel.bandwidth(comm, runs = 99)
print(res)
}
\references{
Carvalho, J.C. & Cardoso, P. (2025) Quantifying species distribution within the functional space.
}
\seealso{
\code{\link[boot]{boot}}, \code{\link[boot]{boot.ci}}
}
