% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{gdm}
\alias{gdm}
\title{General dynamic model of oceanic island biogeography (GDM).}
\usage{
gdm(comm, tree, area, time)
}
\arguments{
\item{comm}{Either a vector with the diversity values per island, or an island x species matrix.}

\item{tree}{A phylo or hclust object (used only for PD or FD) or alternatively a species x traits matrix or data.frame to build a functional tree (used only to fit the PD or FD GDM, requires comm to be a sites x species matrix).}

\item{area}{A vector with the area of islands.}

\item{time}{A vector with the age of islands. If not given, the species-area relationship is returned instead.}
}
\value{
A matrix with the different model parameters and explanatory power.
}
\description{
Fits and compares several of the most supported models for the GDM (using TD, PD or FD).
}
\details{
The general dynamic model of oceanic island biogeography was proposed to account for diversity patterns within and across oceanic archipelagos as a function of area and age of the islands (Whittaker et al. 2008).
Several different equations have been found to describe the GDM, extending the different SAR models with the addition of a polynomial term using island age and its square (TT2), depicting the island ontogeny.
The first to be proposed was an extension of the exponential model (Whittaker et al. 2008), the power model extensions following shortly after (Fattorini 2009; Steinbauer et al. 2013), as was the linear model (Cardoso et al. 2020).
The relationships for PD and FD are calculated based on a tree (hclust or phylo object, no need to be ultrametric).
}
\examples{
div <- c(1,3,5,8,10)
comm <- matrix(c(2,0,0,0,3,1,0,0,2,4,5,0,1,3,2,5,1,1,1,1), nrow = 5, ncol = 4, byrow = TRUE)
tree <- tree.build(gower(1:4))
area <- c(10,40,80,160,160)
time <- c(1,2,3,4,5)
gdm(div,,area,time)
gdm(comm,tree,area,time)
gdm(div,,area)
}
\references{
Cardoso, P., Branco, V.V., Borges, P.A.V., Carvalho, J.C., Rigal, F., Gabriel, R., Mammola, S., Cascalho, J. & Correia, L. (2020) Automated discovery of relationships, models and principles in ecology. Frontiers in Ecology and Evolution, 8: 530135.

Fattorini, S. (2009) On the general dynamic model of oceanic island biogeography. Journal of Biogeography, 36: 1100-1110.

Steinbauer, M.J, Klara, D., Field, R., Reineking, B. & Beierkuhnlein, C. (2013) Re-evaluating the general dynamic theory of oceanic island biogeography. Frontiers of Biogeography, 5: 185-194.

Whittaker, R.J., Triantis, K.A. & Ladle, R.J. (2008) A general dynamic theory of oceanic island biogeography. Journal of Biogeography, 35: 977-994.
}
